var _ = require('lodash');
var admin = require('firebase-admin')
var cwd = process.cwd();
//var serviceAccount = require(cwd + '/assa-service-firebase-adminsdk-ppiln-66f55ab3e9.json')
var serviceAccount = require(cwd + '/assa-smile-1531728056136-firebase-adminsdk-tsgdp-87cfa01f38.json')
var moment = require('moment');
				
admin.initializeApp({
    credential: admin.credential.cert(serviceAccount),
    //databaseURL: 'https://assa-service.firebaseio.com'
    databaseURL: sails.config.local.dbFirebase
})

module.exports = {
	addZero: function (str, max) {
		str = str.toString();
		return (str.length < max ? this.addZero("0" + str, max) : str);
	},
	broadcastNotif: function (title, msg, obj, obj_id, cb) {

		Client.find({ gcm_id: { '!': ' ' }, status: 2 }).exec(function (err, foundUser) {
			if (foundUser.length) {

				async.waterfall([
					function initByOs(cb2) {
						var byOs = _.groupBy(foundUser, 'os')
						var response = {}
						cb2(null, byOs, response)
					},
					function excAndroid(byOs, response, cb2) {
						//console.log('------ excAndroid')
						response.android = {}
						if (byOs.android && byOs.android.length) {
							response.android.qty = byOs.android.length
							response.android.err = 0
							response.android.success = 0
							async.eachSeries(byOs.android, function (item, next) {
								console.log('--- excAndroid sendFCM', item.id) 
								GlobalFunction.sendFCM(item.id, title, msg, obj, obj_id, function (err, respon) {
									if (err) {
										response.android.err++
										console.log('>>>>> err FCM', err) // return cb(err)
									}
									else response.android.success++

									// console.log('--------- excAndroid sendFCM Respon', respon)
									next();
								});
							}, function allDone() {
								//console.log('end off eachSeries android...')
								cb2(null, byOs, response)
							})

							/* ============== SISTEM Chunk
							var chunk = 100
							var androidChunk = _.chunk(byOs.android, chunk);
							async.eachSeries(androidChunk, function(itemPart, next){
								var arrayGCM = _.map(item, 'gcm_id') next();
							}, function allDone(){ console.log('end off eachSeries android...') cb(null, byOs) }) */
						}
						else {
							console.log('--- excAndroid not found')
							cb2(null, byOs, response)
						}
					},
					function excIos(byOs, response, cb2) {
						console.log('------ excIos')
						response.ios = {}
						if (byOs.ios && byOs.ios.length) {
							response.ios.qty = byOs.ios.length
							response.ios.err = 0
							response.ios.success = 0
							async.eachSeries(byOs.ios, function (item, next) {
								console.log('--- excIos sendFCM', item.id)
								GlobalFunction.sendFCM(item.id, title, msg, obj, obj_id, function (err, respon) {
									if (err) {
										response.ios.err++
										console.log('>>>>> err FCM', err) // return cb(err)
									}
									else response.ios.success++

									// console.log('--------- excIos sendFCM Respon', respon)
									next();
								});
							}, function allDone() {
								console.log('end off eachSeries ios...')
								cb2(null, response)
							})
						}
						else {
							console.log('--- excIos not found')
							cb2(null, response)
						}
					}
				], function Alldone(err, response) {
					console.log('--- broadcastNotif done')
					if (err) return cb(err);
					else return cb(null, response);
				});
			}
		});
	},
	sendFCM: function (idClient, title, msg, obj, obj_id, cb) {
		
		async.waterfall([
			function findDetail(cb2) {
				Client.findOne({ id: idClient }).exec(function (err, foundUser) {
					if (_.isObject(foundUser)) {
						if (!foundUser.gcm_id) return cb2('sendFCM - user '+idClient+' no have tokenFCM');
						else return cb2(null, foundUser)
					}
				});
			}
		], function Alldone(err, foundUser) {
			if (err) return cb(err);
			
			var dataNotif = {}
			dataNotif.title = title
			dataNotif.message = msg
			dataNotif.object = obj
			dataNotif.object_id = obj_id
			dataNotif.client = idClient
			dataNotif.is_read = 0
			dataNotif.deleted = 0
			
			
				
			var registrationToken = foundUser.gcm_id // 'c38DZzm86ao:APA91bEhG12Y05pb2qrSNSlSOo2O8WgHTodn-WBHh_FLhWTjE_rD09QXTd2mCn5ne-uOmIRmgJ_vxouVY9zO_lL1a1gqrwFeMp0OZNFvc4r4L4KuSNgo76DawdAG-ZEeusuPyuav2Z0I'
			
			NotifCenterMobile.create(dataNotif).exec(function (err, newNotif) {
				if (err) console.log('err - ServicePoint.create', err)
				newNotif.client = newNotif.client.toString()
				newNotif.id = newNotif.id.toString()
				newNotif.object_id = newNotif.object_id.toString() 
				newNotif.is_read = newNotif.is_read.toString()
				newNotif.deleted = newNotif.deleted.toString()
				newNotif.createdAt = newNotif.createdAt.toString()
				newNotif.updatedAt = newNotif.updatedAt.toString()
				
				// console.log("sendFCM - newNotif", newNotif)
				
				var message = {
					data: newNotif
				}
				const regex = /(<([^>]+)>)/gi
				if(obj=='chat'){
					newNotif.message.replace(regex,'').replace(/&nbsp;/g, ' ');
				}
				message.notification = {
			        title: newNotif.title,
			        body: newNotif.message
			    }
			    message.android = {
			        collapseKey: 'assaNotificationKey',
			        restrictedPackageName: 'com.aksimaya.assasmile',
			        notification: {
			            icon: 'ic_notifications',
			            color: '#d0ab2a',
			            sound: 'default',
			            tag: newNotif.object
			        }
			    }
			    message.token = registrationToken 
				
				if (foundUser.os == 'android') {
					var notificationId = null;
					admin
					    .messaging() 
					    .send(message)
					    .then(response => {
					    	console.log('Successfully sent message:', response)
					    	var resNotif = { response: response }
					    	var splitNotificationId = response.split("/")
							notificationId = splitNotificationId[splitNotificationId.length - 1];
							NotifCenterMobile.update(newNotif.id, { notificationId: notificationId, respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
								if (err) console.log('error NotifCenterMobile.update: ', err);
							});
							return cb(null, response);
					    })
					    .catch(error => {
					    	// console.error('Error sending message:', error)
					    	var resNotif = { error: error }
							NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
								if (err) console.log('error NotifCenterMobile.update: ', err);
							});
							return cb(error);
				    	})
				}
				
				if (foundUser.os == 'ios') {
					/*var options = {
						collapseKey: 'collapseKey',
						priority: 'high',
						restrictedPackageName: 'com.aksimaya.assasmile',
						contentAvailable:true
					}*/
					
					/*message.apns = {
					        payload: {
					            aps: {
					                alert: { title: newNotif.title, body: newNotif.message },
					                'content-available': 1,
					                'collapse-key':'assaNotificationKey',
					               // badge: 42
					            }
					        }
					}
					admin
					    .messaging() 
					    .send(message)
					    .then(response => {
					    	// console.log('Successfully sent message:', response)
					    	var resNotif = { response: response }
							NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
								if (err) console.log('error NotifCenterMobile.update: ', err);
							});
							
							return cb(null, response);
					    })
					    .catch(error => {
					    	// console.error('Error sending message:', error)
					    	var resNotif = { error: error }
							NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
								if (err) console.log('error NotifCenterMobile.update: ', err);
							});
							return cb(error);
				    	})*/
				    
				    
				    var getNotificationMobileToday = function(call) {
				    	var todaySmartWhere = new Date();
						var smart_where = {};
						smart_where.client = idClient;
						smart_where.is_read = 0;
						smart_where.deleted = 0;
						smart_where.createdAt = {
							'>=': moment(todaySmartWhere).startOf('day').format('YYYY-MM-DD HH:mm'),
							'<=': moment(todaySmartWhere).endOf('day').format('YYYY-MM-DD HH:mm')
						};
						NotifCenterMobile.find(smart_where).exec(function(errFindNotifCenterMobile, doneFindNotifCenterMobile) {
							var numberOfLengthNotifCenterMobile = 0;
							if (errFindNotifCenterMobile) {
								console.log('getNotificationMobileToday err:', errFindNotifCenterMobile);
							} else {
								console.log('getNotificationMobileToday done:', doneFindNotifCenterMobile.length);
								numberOfLengthNotifCenterMobile = doneFindNotifCenterMobile.length;
							}
							return call(numberOfLengthNotifCenterMobile)
						});
				    }
				    
				    async.waterfall([
				    	getNotificationMobileToday
				    ], function(numberOfLengthNotifCenterMobile) {
				    	var notificationId = null;
				    	message.apns = {
						        payload: {
						            aps: {
						                alert: { title: newNotif.title, body: newNotif.message },
						                'content-available': 1,
						                'collapse-key':'assaNotificationKey',
						               badge: numberOfLengthNotifCenterMobile,
						               sound: 'default'
						            }
						        }
						}
						admin
						    .messaging() 
						    .send(message)
						    .then(response => {
						    	// console.log('Successfully sent message:', response)
						    	var resNotif = { response: response }
								var splitNotificationId = response.split("/")
								notificationId = splitNotificationId[splitNotificationId.length - 1];
								NotifCenterMobile.update(newNotif.id, { notificationId: notificationId, respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
									if (err) console.log('error NotifCenterMobile.update: ', err);
								});
								
								return cb(null, response);
						    })
						    .catch(error => {
						    	// console.error('Error sending message:', error)
						    	var resNotif = { error: error }
								NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
									if (err) console.log('error NotifCenterMobile.update: ', err);
								});
								return cb(error);
					    	})
				    })
				    
				}
			})
			
		})
	},
	sendGCM: function (idClient, title, msg, obj, obj_id, cb) {

		async.waterfall([
			function findDetail(cb2) {
				Client.findOne({ id: idClient }).exec(function (err, foundUser) {
					if (_.isObject(foundUser)) {
						if (!foundUser.gcm_id) return cb2('sendGCM - user no have tokenGcm');
						else return cb2(null, foundUser)
					}
				});
			}
		], function Alldone(err, foundUser) {
			if (err) return cb(err);

			var dataNotif = {}
			dataNotif.title = title
			dataNotif.message = msg
			dataNotif.object = obj
			dataNotif.object_id = obj_id
			dataNotif.client = idClient
			dataNotif.is_read = 0
			dataNotif.deleted = 0

			if (foundUser.os == 'android') {
				var gcm = require('node-gcm');
				Config.findOne({ GROUP_CONFIG: 'GCM', VARIABLE: 'api_key' }).exec(function (err, foundConfig) {
					if (err) return cb(err);

					NotifCenterMobile.create(dataNotif).exec(function (err, newNotif) {
						if (err) console.log('err - ServicePoint.create', err)

						newNotif.deleted = parseInt(newNotif.deleted)
						newNotif.is_read = parseInt(newNotif.is_read)

						var sender = new gcm.Sender('AIzaSyCXq2ZbaTtOCeQodWwLJjtCP9B0IYkqbzA'); // foundConfig.VAL_CONFIG 

						var message = new gcm.Message({
							collapseKey: 'ASSACarMaintenance',
							// priority: 'high',
							// contentAvailable: true,
							// delayWhileIdle: false,
							timeToLive: 86400,
							restrictedPackageName: 'com.aksimaya.assasmile',
							data: {
								title: newNotif.title,
								message: newNotif.message,
								icon: 'ic_assignment',
								sound: 'default',
								tag: 'carmaintenance',
								color: '#d0ab2a',
								click_action: 'Notification clicked!',
								data: newNotif
							}
						});


						var regTokens = [foundUser.gcm_id];
						sender.send(message, { registrationTokens: regTokens }, function (err, response) {

							var resNotif = { err: err, response: response }
							NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
								if (err) console.log('error NotifCenterMobile.update: ', err);
							});

							if (err) return cb(err);
							else return cb(null, response);
						});
					});
				});
			}

			var cwd = process.cwd();

			if (foundUser.os == 'ios') {
				const apn = require("apn");

				// var tokens = ["79ed58811b35b163d0e52405a518f57803a4455a623506ebe41e58336cc0f4cb"];
				var tokens = foundUser.gcm_id

				var service = new apn.Provider({
					// Account Punya Aksimaya
				    /*
				    token: {
				        key: cwd + "/AuthKey_UY6K2B96Y5.p8",
				        keyId: "UY6K2B96Y5",
				        teamId: "3ZJQ9NTLTP"
				    } */

					// Account Punya ASSA 
					token: {
						key: cwd + "/AuthKey_S8FBZ9SD2T.p8",
						keyId: "S8FBZ9SD2T",
						teamId: "R46AP2SU9X"
					},
				});

				NotifCenterMobile.create(dataNotif).exec(function (err, newNotif) {
					if (err) console.log('err - ServicePoint.create', err)

					newNotif.deleted = parseInt(newNotif.deleted)
					newNotif.is_read = parseInt(newNotif.is_read)

					var note = new apn.Notification({
						alert: newNotif.title,
						payload: newNotif,
						// badge: 3,
						sound: "ping.aiff"
					});

					// The topic is usually the bundle identifier of your application.
					note.topic = "com.aksimaya.assasmile";

					//console.log('clinet', idClient)
					//console.log(`Sending: ${note.compile()} to ${tokens}`);
					service.send(note, tokens).then(result => {

						NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(result) }).exec(function (err, respon) {
							if (err) console.log('error NotifCenterMobile.update: ', err);
						});

						//console.log("sent:", result.sent.length);
						//console.log("failed:", result.failed.length);
						//console.log(result.failed);
						if (result.failed.length) return cb(result.failed)
						else return cb(null, result);
					});

					service.shutdown();
				})
			}
		});



	},
	sendSms: function (dataParams, cb) {
		Config.find({ GROUP_CONFIG: 'SMSGATEWAY' }).sort('CONFIG_ID ASC').exec(function (err, foundConfig) {
			if (err) return res.badRequest(err);
			var http = require('http');
			var querystring = require('querystring');
			
			/*var params = {
				username :foundConfig[1].VAL_CONFIG,
				mobile: dataParams.mobile, // ini di ambil dari no telp customer di booking
				message : dataParams.message, //ini di ambil dari config sms template + secretcode
				auth:require("crypto").createHash("md5").update('assarent'+foundConfig[2].VAL_CONFIG+dataParams.mobile).digest("hex"),
				trxID : dataParams.trxID, // ini ambil dari booking ID aja
				type:0
			}
			GANTI VENDOR SMSGATEWAY
			* */
			/*
			var params = {
				username: foundConfig[1].VAL_CONFIG,
				hp: dataParams.mobile, // ini di ambil dari no telp customer di booking
				message: dataParams.message, //ini di ambil dari config sms template + secretcode
				password: foundConfig[2].VAL_CONFIG
			}
			*/
			
			/* 
			 * disable 11/12/2019
			 * pake struktur baru
			var params = {
				username: foundConfig[1].VAL_CONFIG,
				password: foundConfig[2].VAL_CONFIG,
				from: 'ASSARENT',
				to: phone, // ini di ambil dari no telp customer di booking
				text: dataParams.message, //ini di ambil dari config sms template + secretcode
				'dlr-mask': 19,
				'dlr-url': ''
			}
			
			var options = {
				host: foundConfig[0].VAL_CONFIG,
				// port: 80,
				// path: '/api/sendSMS.php?'+querystring.stringify(params)
				// path: '/masking/send.php?' + querystring.stringify(params)
				path: '/smpp/sendsms?' + querystring.stringify(params)
			};
			*/
			
			var valid = true;
			var phone = dataParams.mobile 
			if(phone.length < 8) valid = false;
			if(phone.substring(0, 1) == '0') phone = '62' + phone.substring(1, phone.length)  
			if(phone.substring(0, 2) != '62') valid = false;
			if(!(/^\d+$/.test(phone))) valid = false;
			
			if(!valid) { 
				cb({ status: 'error', message: 'No. ' + phone + ' tidak valid' }); 
				return;
			}
			
			// struktur config baru 
			// 11/12/2019
			var conf = _.keyBy(foundConfig, 'VARIABLE');
			var msg = dataParams.message ? encodeURI(dataParams.message) : '';
			var apiParam = conf.API_PARAMS.VAL_CONFIG.replace('[TO]', phone).replace('[MESSAGE]', msg)
			
			var options = {
				host: conf.API_URL.VAL_CONFIG,
				path: conf.API_PATH.VAL_CONFIG + '?' + apiParam
			};
			
			if(conf.API_PORT.VAL_CONFIG != '') options.port = conf.API_PORT.VAL_CONFIG 
			console.log('options', options)
			
			http.get(options, function (response) {
				var body = '';
				response.on('data', function (chunk) {
					body += chunk;
				});
				response.on('end', function () {
					console.log('Return from SMS API', body)
					cb({ status: 'success', message: body })
				});
			}).on("error", function (e) {
				console.log("Got error: " + e.message);
				cb({ status: 'error', message: e.message })
			});
		});

	},
	sendMail: function (options, cb) {
		const nodemailer = require('nodemailer');
		Config.find({ GROUP_CONFIG: 'SMTP_MAIL' }).exec(function (err, foundConfig) {
			var hashMap = {};
			for (var i = 0; i < foundConfig.length; i++) {
				hashMap[foundConfig[i].VARIABLE] = foundConfig[i].VAL_CONFIG;
			}
			//console.log('hashMap',hashMap);		
			// create reusable transporter object using the default SMTP transport
			var transporter = nodemailer.createTransport({
				host: hashMap['host'],
				port: hashMap['port'],
				secure: true, // secure:true for port 465, secure:false for port 587
				auth: {
					user: hashMap['user'],
					pass: hashMap['pass']
				}
			});

			// setup email data with unicode symbols
			var mailOptions = {
				from: '"ASSA Solution Center" ' + (options.from) ? options.from : hashMap['user'],  // sender address
				to: options.to, // list of receivers
				subject: options.subjectMail, // Subject line
				text: options.textBodyMail, // plain text body
				html: options.htmlBodyMail // html body
			};
			console.log('mailOptions', mailOptions);
			// send mail with defined transport object
			try {
				transporter.sendMail(mailOptions, (error, info) => {
					if (error) {
						cb(error);
						console.log(error);
					} else (
						cb(null, 'message id : ' + info.messageId + ',info :' + info.response)
					)
					//console.log('Message %s sent: %s', info.messageId, info.response);
				});
			} catch (err) {
				cb(err.message);
			}

		});

	},
	sendFCMForBlast: function (idClient, title, msg, obj, obj_id, cb) { // add by yusup - kalau pakai yg om epul timeout.
		
		async.waterfall([
			function findDetail(cb2) {
				Client.findOne({ id: idClient }).exec(function (err, foundUser) {
					if (_.isObject(foundUser)) {
						if (!foundUser.gcm_id) return cb2('sendFCM - user '+idClient+' no have tokenFCM');
						else return cb2(null, foundUser)
					}
				});
			}
		], function Alldone(err, foundUser) {
			if (err) return cb(err);
			
			var dataNotif = {}
			dataNotif.title = title
			dataNotif.message = msg
			dataNotif.object = obj
			dataNotif.object_id = obj_id
			dataNotif.client = idClient
			dataNotif.is_read = 0
			dataNotif.deleted = 0
			
			
				
			var registrationToken = foundUser.gcm_id // 'c38DZzm86ao:APA91bEhG12Y05pb2qrSNSlSOo2O8WgHTodn-WBHh_FLhWTjE_rD09QXTd2mCn5ne-uOmIRmgJ_vxouVY9zO_lL1a1gqrwFeMp0OZNFvc4r4L4KuSNgo76DawdAG-ZEeusuPyuav2Z0I'
			
			if (registrationToken !== null) {
				NotifCenterMobile.create(dataNotif).exec(function (err, newNotif) {
					if (err) console.log('err - ServicePoint.create', err)
					newNotif.client = newNotif.client.toString()
					newNotif.id = newNotif.id.toString()
					newNotif.object_id = newNotif.object_id.toString() 
					newNotif.is_read = newNotif.is_read.toString()
					newNotif.deleted = newNotif.deleted.toString()
					newNotif.createdAt = newNotif.createdAt.toString()
					newNotif.updatedAt = newNotif.updatedAt.toString()
					
					// console.log("sendFCM - newNotif", newNotif)
					
					var message = {
						data: newNotif
					}
					
					
					message.notification = {
				        title: newNotif.title,
				        body: newNotif.message
				    }
				    message.android = {
				        collapseKey: 'assaNotificationKey',
				        restrictedPackageName: 'com.aksimaya.assasmile',
				        notification: {
				            icon: 'ic_notifications',
				            color: '#d0ab2a',
				            sound: 'default',
				            tag: newNotif.object
				        }
				    }
				    message.token = registrationToken 
					
					if (foundUser.os == 'android') {
						admin
						    .messaging() 
						    .send(message)
						    .then(response => {
						    	console.log('Successfully sent message:', response)
						    	var resNotif = { response: response }
								NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
									if (err) console.log('error NotifCenterMobile.update: ', err);
								});
								
								return cb(null, response);
						    })
						    .catch(error => {
						    	// console.error('Error sending message:', error)
						    	var resNotif = { error: error }
								NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
									if (err) console.log('error NotifCenterMobile.update: ', err);
								});
								return cb(error);
					    	})
					}
					
					if (foundUser.os == 'ios') {
						/*var options = {
							collapseKey: 'collapseKey',
							priority: 'high',
							restrictedPackageName: 'com.aksimaya.assasmile',
							contentAvailable:true
						}*/
						message.apns = {
						        payload: {
						            aps: {
						                alert: { title: newNotif.title, body: newNotif.message },
						                'content-available': 1,
						                'collapse-key':'assaNotificationKey',
						               // badge: 42
						            }
						        }
						}
						admin
						    .messaging() 
						    .send(message)
						    .then(response => {
						    	// console.log('Successfully sent message:', response)
						    	var resNotif = { response: response }
								NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
									if (err) console.log('error NotifCenterMobile.update: ', err);
								});
								
								return cb(null, response);
						    })
						    .catch(error => {
						    	// console.error('Error sending message:', error)
						    	var resNotif = { error: error }
								NotifCenterMobile.update(newNotif.id, { respon: JSON.stringify(resNotif) }).exec(function (err, respon) {
									if (err) console.log('error NotifCenterMobile.update: ', err);
								});
								return cb(error);
					    	})
					}
				})
			} else {
				return cb("gcm_id null");
			}
			
			
			
		})
	}
}