package com.tenforwardconsulting.cordova.bgloc;

import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONArray;
import org.json.JSONException;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.util.Log;

public class BackgroundGpsPlugin extends CordovaPlugin {
	private static final String TAG = "BackgroundGpsPlugin";

	public static final String ACTION_START = "start";
	public static final String ACTION_STOP = "stop";
	public static final String ACTION_CONFIGURE = "configure";

	private Intent updateServiceIntent;

	private String authToken;
	private String url;
	private String stationaryRadius = "30";
	private String desiredAccuracy = "100";
	private String distanceFilter = "30";
	private String locationTimeout = "60";
	private String isDebugging = "false";

	public boolean execute(String action, JSONArray data, CallbackContext callbackContext) {
		Activity activity = this.cordova.getActivity();
		updateServiceIntent = new Intent(activity, LocationUpdateService.class);
		if (ACTION_START.equalsIgnoreCase(action)) {
			if (authToken == null || url == null) {
				callbackContext.error("Call configure before calling start");
				return false;
			}
			updateServiceIntent.putExtra("authToken", authToken);
			updateServiceIntent.putExtra("url", url);
			updateServiceIntent.putExtra("stationaryRadius", stationaryRadius);
			updateServiceIntent.putExtra("desiredAccuracy", desiredAccuracy);
			updateServiceIntent.putExtra("distanceFilter", distanceFilter);
			updateServiceIntent.putExtra("locationTimeout", locationTimeout);
			updateServiceIntent.putExtra("desiredAccuracy", desiredAccuracy);
			updateServiceIntent.putExtra("isDebugging", isDebugging);

			activity.startService(updateServiceIntent);

		} else if (ACTION_STOP.equalsIgnoreCase(action)) {
			activity.stopService(updateServiceIntent);
		} else if (ACTION_CONFIGURE.equalsIgnoreCase(action)) {
			try {
				// [authToken, url, stationaryRadius, distanceFilter, locationTimeout, desiredAccuracy, debug]);

				this.authToken = data.getString(0);
				this.url = data.getString(1);
				this.stationaryRadius = data.getString(2);
				this.distanceFilter = data.getString(3);
				this.locationTimeout = data.getString(4);
				this.desiredAccuracy = data.getString(5);
				this.isDebugging = data.getString(6);

			} catch (JSONException e) {
				callbackContext.error("authToken/url required as parameters: " + e.getMessage());
				return false;
			}
		}

		return true;
	}
}
