/*
 * Decompiled with CFR 0.152.
 */
package com.transistorsoft.locationmanager;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.transistorsoft.locationmanager.BackgroundGeolocationService;
import com.transistorsoft.locationmanager.GeofenceService;
import org.json.JSONException;
import org.json.JSONObject;

public class TSGeofence {
    public String identifier;
    public double latitude;
    public double longitude;
    public float radius;
    public int transitionTypes;
    public int loiteringDelay;
    public int notificationResponsiveness;
    public PendingIntent pendingIntent;

    public TSGeofence(String _identifier, float _radius, double _latitude, double _longitude) {
        this.identifier = _identifier;
        this.radius = _radius;
        this.latitude = _latitude;
        this.longitude = _longitude;
    }

    public GeofencingRequest getGeofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        Geofence geofence = new Geofence.Builder().setRequestId(this.identifier).setCircularRegion(this.latitude, this.longitude, this.radius).setExpirationDuration(-1L).setTransitionTypes(3).build();
        builder.addGeofence(geofence);
        return builder.build();
    }

    public PendingIntent getGeofencePendingIntent(BackgroundGeolocationService context) {
        Intent intent = new Intent((Context)context, GeofenceService.class);
        this.pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        return this.pendingIntent;
    }

    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("identifier", (Object)this.identifier);
            json.put("radius", (double)this.radius);
            json.put("latitude", this.latitude);
            json.put("longitude", this.longitude);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }
}

