/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.event;

import de.greenrobot.event.EventBusException;
import de.greenrobot.event.SubscriberMethod;
import de.greenrobot.event.ThreadMode;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

abstract class SubscriberIndex {
    private Map<Class<?>, SubscriberMethod[]> map = new HashMap();

    SubscriberIndex() {
    }

    SubscriberMethod[] getSubscribersFor(Class<?> subscriberClass) {
        SubscriberMethod[] entries = this.map.get(subscriberClass);
        if (entries == null && (entries = this.createSubscribersFor(subscriberClass)) != null) {
            this.map.put(subscriberClass, entries);
        }
        return entries;
    }

    abstract SubscriberMethod[] createSubscribersFor(Class<?> var1);

    SubscriberMethod createSubscriberMethod(Class<?> subscriberClass, String methodName, Class<?> eventType, ThreadMode threadMode, int priority, boolean sticky) {
        try {
            Method method = subscriberClass.getDeclaredMethod(methodName, eventType);
            return new SubscriberMethod(method, eventType, threadMode, priority, sticky);
        }
        catch (NoSuchMethodException e) {
            throw new EventBusException("Could not find subscriber method in " + subscriberClass + ". Maybe a missing ProGuard rule?", e);
        }
    }
}

