package com.transistorsoft.locationmanager;

import org.json.JSONException;
import org.json.JSONObject;
import android.app.PendingIntent;
import android.content.Intent;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;

/**
 * Helper class for building a Geofence
 */
public class TSGeofence {
	private static int nextId = 0;
	private static int getId() {
		return ++nextId;
	}

	private int id;
	public String identifier;
	public double latitude;
	public double longitude;
	public float radius;
	public boolean notifyOnEntry;
	public boolean notifyOnExit;
	public int transitionTypes;
	public int loiteringDelay;
	public int notificationResponsiveness;
	public PendingIntent pendingIntent;
	
	public TSGeofence(String _identifier, float _radius, double _latitude, double _longitude, boolean _notifyOnEntry, boolean _notifyOnExit) {
		id 			= getId();
		identifier 	= _identifier;
		radius 		= _radius;
		latitude 	= _latitude;
		longitude 	= _longitude;
		notifyOnEntry = _notifyOnEntry;
		notifyOnExit = _notifyOnExit;
		
		transitionTypes = 0;
		if (notifyOnEntry) {
			transitionTypes = transitionTypes | Geofence.GEOFENCE_TRANSITION_ENTER;
		}
		if (notifyOnExit) {
			transitionTypes = transitionTypes | Geofence.GEOFENCE_TRANSITION_EXIT;
		}
		else {
			transitionTypes = Geofence.GEOFENCE_TRANSITION_ENTER | Geofence.GEOFENCE_TRANSITION_EXIT;
		}
	}
	public GeofencingRequest getGeofencingRequest() {
    	GeofencingRequest.Builder builder = new GeofencingRequest.Builder();

        // The INITIAL_TRIGGER_ENTER flag indicates that geofencing service should trigger a
        // GEOFENCE_TRANSITION_ENTER notification when the geofence is added and if the device
        // is already inside that geofence.
        builder.setInitialTrigger(GeofencingRequest.INITIAL_TRIGGER_ENTER);
        
        Geofence geofence = new Geofence.Builder()
        // Set the request ID of the geofence. This is a string to identify this
        // geofence.
        .setRequestId(identifier)
        .setCircularRegion(
        	latitude,
        	longitude,
            radius
        )
        .setExpirationDuration(Geofence.NEVER_EXPIRE)
        .setTransitionTypes(transitionTypes)
        .build();
        
        // Add the geofences to be monitored by geofencing service.
        builder.addGeofence(geofence);

        // Return a GeofencingRequest.
        return builder.build();
    }
	public PendingIntent getGeofencePendingIntent(BackgroundGeolocationService context) {
        Intent intent = new Intent(context, GeofenceService.class);
        // We use FLAG_UPDATE_CURRENT so that we get the same pending intent back when
        // calling addGeofences() and removeGeofences().
        pendingIntent = PendingIntent.getService(context, id, intent, PendingIntent.FLAG_UPDATE_CURRENT);
        return pendingIntent;
    }
	public JSONObject asJson() {
		JSONObject json = new JSONObject();
		try {
			json.put("identifier", identifier);
			json.put("radius", radius);
			json.put("latitude", latitude);
			json.put("longitude", longitude);
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return json;
	}
}
