/*
 * Decompiled with CFR 0.152.
 */
package com.transistorsoft.locationmanager.data.sqlite;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.transistorsoft.locationmanager.data.LocationDAO;
import com.transistorsoft.locationmanager.data.TSLocation;
import com.transistorsoft.locationmanager.data.sqlite.LocationOpenHelper;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SQLiteLocationDAO
implements LocationDAO {
    private static final String TAG = "TSLocationManager";
    private Context context;

    public SQLiteLocationDAO(Context context) {
        this.context = context;
    }

    @Override
    public List<TSLocation> all() {
        SQLiteDatabase db = null;
        Cursor c = null;
        ArrayList<TSLocation> rs = new ArrayList<TSLocation>();
        try {
            db = new LocationOpenHelper(this.context).getReadableDatabase();
            c = db.query(false, "locations", null, null, null, null, null, null, null);
            while (c.moveToNext()) {
                rs.add(this.hydrate(c));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return rs;
    }

    @Override
    public List<TSLocation> allWithLocking() {
        SQLiteDatabase db = null;
        Cursor c = null;
        ArrayList<TSLocation> rs = new ArrayList<TSLocation>();
        try {
            db = new LocationOpenHelper(this.context).getWritableDatabase();
            c = db.query(false, "locations", null, "locked=0", null, null, null, null, null);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            while (c.moveToNext()) {
                ids.add(c.getInt(0));
                rs.add(this.hydrate(c));
            }
            ContentValues values = new ContentValues();
            values.put("locked", Integer.valueOf(1));
            int result = db.update("locations", values, "id IN (" + TextUtils.join((CharSequence)",", ids) + ")", null);
            Log.i((String)TAG, (String)("Locked " + result + " records"));
        }
        finally {
            if (c != null) {
                c.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return rs;
    }

    @Override
    public boolean unlock(Integer id) {
        SQLiteDatabase db = new LocationOpenHelper(this.context).getWritableDatabase();
        db.beginTransaction();
        ContentValues values = new ContentValues();
        values.put("locked", Integer.valueOf(0));
        int result = db.update("locations", values, "id=?", new String[]{id.toString()});
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
        return result == 1;
    }

    @Override
    public boolean persist(JSONObject location) {
        SQLiteDatabase db = new LocationOpenHelper(this.context).getWritableDatabase();
        db.beginTransaction();
        ContentValues values = this.getContentValues(location);
        long id = db.insert("locations", null, values);
        try {
            String timestamp = location.getString("timestamp");
            Log.d((String)TAG, (String)("- INSERT, id: " + id + ", timestamp: " + timestamp));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
        return id > -1L;
    }

    @Override
    public void prune(Integer daysBeforeNow) {
        SQLiteDatabase db = new LocationOpenHelper(this.context).getWritableDatabase();
        db.beginTransaction();
        Log.i((String)TAG, (String)("- PRUNE -" + daysBeforeNow + "days"));
        db.delete("locations", "datetime(timestamp) < datetime('now', '-" + daysBeforeNow + " day')", null);
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
    }

    @Override
    public boolean destroy(Integer id) {
        SQLiteDatabase db = new LocationOpenHelper(this.context).getWritableDatabase();
        db.beginTransaction();
        Integer result = db.delete("locations", "id = ?", new String[]{id.toString()});
        if (result == 1) {
            Log.i((String)TAG, (String)("- DELETE SUCCESS: " + id));
        } else {
            Log.i((String)TAG, (String)("- DELETE FAILURE: " + id));
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
        return result == 1;
    }

    @Override
    public void destroyAll(List<TSLocation> rs) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (TSLocation location : rs) {
            ids.add(location.id);
        }
        SQLiteDatabase db = new LocationOpenHelper(this.context).getWritableDatabase();
        db.beginTransaction();
        Integer result = db.delete("locations", "id IN (" + TextUtils.join((CharSequence)",", ids) + ")", null);
        if (result.intValue() == rs.size()) {
            Log.i((String)TAG, (String)("- DELETE SUCCESS (" + result + ")"));
        } else {
            Log.i((String)TAG, (String)("- DELETE FAILURE (" + result + ")"));
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
    }

    private TSLocation hydrate(Cursor c) {
        return new TSLocation(this, c.getInt(c.getColumnIndex("id")), c.getString(c.getColumnIndex("timestamp")), c.getString(c.getColumnIndex("json")));
    }

    private ContentValues getContentValues(JSONObject location) {
        ContentValues values = new ContentValues();
        try {
            values.put("json", location.toString());
            values.put("timestamp", location.getString("timestamp"));
            values.put("locked", Integer.valueOf(0));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return values;
    }
}

