package com.transistorsoft.locationmanager;

import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;

import de.greenrobot.event.EventBus;

import android.app.IntentService;
import android.content.Intent;
import android.util.Log;

public class GeofenceService extends IntentService {

	private static final String TAG = "TSLocationManager";
	
	public GeofenceService() {
		super("com.transistorsoft.locationmanager.GeofenceService");
	}

	@Override
	protected void onHandleIntent(Intent intent) {
		GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent(intent);
		Log.i(TAG, "- GeofenceService#onHandleIntent: " + geofencingEvent);
        
		if (geofencingEvent.hasError()) {
            Log.e(TAG, "- Geofencing error" + geofencingEvent.getErrorCode());
            return;
        }
        
        // Get the transition type.
        int geofenceTransition = geofencingEvent.getGeofenceTransition();

        // Test that the reported transition was of interest.
        if (geofenceTransition == Geofence.GEOFENCE_TRANSITION_ENTER || geofenceTransition == Geofence.GEOFENCE_TRANSITION_EXIT) {
            // Send notification and log the transition details.
            EventBus.getDefault().post(geofencingEvent);
        } 
	}
}