/*
 * Decompiled with CFR 0.152.
 */
package com.transistorsoft.locationmanager.data.sqlite;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.transistorsoft.locationmanager.data.LocationDAO;
import com.transistorsoft.locationmanager.data.sqlite.LocationOpenHelper;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class SQLiteLocationDAO
implements LocationDAO {
    private static final String TAG = "TSLocationManager";
    private Context context;

    public SQLiteLocationDAO(Context context) {
        this.context = context;
    }

    @Override
    public JSONObject[] getAllLocations() {
        SQLiteDatabase db = null;
        Cursor c = null;
        ArrayList<JSONObject> all = new ArrayList<JSONObject>();
        try {
            db = new LocationOpenHelper(this.context).getReadableDatabase();
            c = db.query(false, "locations", null, null, null, null, null, null, null);
            while (c.moveToNext()) {
                all.add(this.hydrate(c));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return all.toArray(new JSONObject[all.size()]);
    }

    @Override
    public boolean persistLocation(JSONObject location) {
        SQLiteDatabase db = new LocationOpenHelper(this.context).getWritableDatabase();
        db.beginTransaction();
        ContentValues values = this.getContentValues(location);
        long id = db.insert("locations", null, values);
        try {
            String timestamp = location.getString("timestamp");
            Log.d((String)TAG, (String)("- INSERT, id: " + id + ", timestamp: " + timestamp));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
        return id > -1L;
    }

    @Override
    public void prune(Integer daysBeforeNow) {
        SQLiteDatabase db = new LocationOpenHelper(this.context).getWritableDatabase();
        db.beginTransaction();
        Log.i((String)TAG, (String)("- PRUNE -" + daysBeforeNow + "days"));
        db.delete("locations", "datetime(timestamp) < datetime('now', '-" + daysBeforeNow + " day')", null);
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
    }

    @Override
    public void deleteLocation(String timestamp) {
        SQLiteDatabase db = new LocationOpenHelper(this.context).getWritableDatabase();
        db.beginTransaction();
        Integer result = db.delete("locations", "timestamp = ?", new String[]{timestamp});
        if (result == 1) {
            Log.i((String)TAG, (String)("- DELETE SUCCESS: " + timestamp));
        } else {
            Log.i((String)TAG, (String)("- DELETE FAILURE: " + timestamp));
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
    }

    private JSONObject hydrate(Cursor c) {
        JSONObject l = null;
        try {
            l = new JSONObject(c.getString(c.getColumnIndex("json")));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return l;
    }

    private ContentValues getContentValues(JSONObject location) {
        ContentValues values = new ContentValues();
        try {
            values.put("json", location.toString());
            values.put("timestamp", location.getString("timestamp"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return values;
    }
}

