/*
 * Decompiled with CFR 0.152.
 */
package com.transistorsoft.locationmanager;

import android.app.IntentService;
import android.content.Intent;
import android.util.Log;
import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;
import de.greenrobot.event.EventBus;

public class ActivityRecognitionService
extends IntentService {
    private static final String TAG = "TSLocationManager";

    public ActivityRecognitionService() {
        super("com.transistorsoft.locationmanager.ActivityRecognitionService");
    }

    protected void onHandleIntent(Intent intent) {
        if (ActivityRecognitionResult.hasResult((Intent)intent)) {
            ActivityRecognitionResult result = ActivityRecognitionResult.extractResult((Intent)intent);
            DetectedActivity probableActivity = result.getMostProbableActivity();
            Log.w((String)TAG, (String)("Activity detected:" + this.getActivityName(probableActivity.getType()) + ", confidence:" + probableActivity.getConfidence()));
            switch (probableActivity.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    EventBus.getDefault().post((Object)result);
                    break;
                }
                case 4: {
                    return;
                }
                case 5: {
                    return;
                }
            }
        }
    }

    private String getActivityName(int activityType) {
        switch (activityType) {
            case 0: {
                return "in_vehicle";
            }
            case 1: {
                return "on_bicycle";
            }
            case 2: {
                return "on_foot";
            }
            case 8: {
                return "running";
            }
            case 7: {
                return "walking";
            }
            case 3: {
                return "still";
            }
            case 4: {
                return "unknown";
            }
            case 5: {
                return "tilting";
            }
        }
        return "unknown";
    }
}

