/*
 * Decompiled with CFR 0.152.
 */
package com.transistorsoft.locationmanager;

import android.app.PendingIntent;
import android.app.Service;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.location.Location;
import android.media.ToneGenerator;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.provider.Settings;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.ActivityRecognition;
import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.transistorsoft.locationmanager.ActivityRecognitionService;
import com.transistorsoft.locationmanager.LocationService;
import com.transistorsoft.locationmanager.data.LocationDAO;
import com.transistorsoft.locationmanager.data.TSLocation;
import com.transistorsoft.locationmanager.data.sqlite.SQLiteLocationDAO;
import de.greenrobot.event.EventBus;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BackgroundGeolocationService
extends Service
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final String TAG = "TSLocationManager";
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static BackgroundGeolocationService instance = null;
    public static final String ACTION_GET_LOCATIONS = "getLocations";
    public static final String ACTION_SET_PACE = "setPace";
    public static final String ACTION_SYNC = "sync";
    private LocationDAO locationDAO;
    private GoogleApiClient googleApiClient;
    private ToneGenerator toneGenerator;
    private PendingIntent activityRecognitionPI;
    private PendingIntent locationUpdatePI;
    private LocationRequest locationRequest;
    private Integer desiredAccuracy = 10;
    private Float distanceFilter = Float.valueOf(50.0f);
    private Boolean isDebugging = false;
    private Boolean stopOnTerminate = false;
    private Integer locationUpdateInterval = 60000;
    private Integer fastestLocationUpdateInterval = 30000;
    private long activityRecognitionInterval = 60000L;
    private Integer minimumActivityRecognitionConfidence = 80;
    private Boolean forceReload = false;
    private Integer stopAfterElapsedMinutes = 0;
    private long stopTimeout = 0L;
    private Integer maxDaysToPersist = 1;
    private String url = null;
    private JSONObject params = new JSONObject();
    private JSONObject headers = new JSONObject();
    private Boolean autoSync = true;
    private Boolean batchSync = false;
    private Boolean isEnabled = false;
    private Boolean isMoving = false;
    private Boolean isPaused = true;
    private long stoppedAt = 0L;
    private Calendar lastPrunedAt;
    private Date stopUpdatingLocationAt;
    private Location stationaryLocation;
    private DetectedActivity currentActivity;

    public static boolean isInstanceCreated() {
        return instance != null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        instance = this;
        EventBus eventBus = EventBus.getDefault();
        if (!eventBus.isRegistered((Object)this)) {
            eventBus.register((Object)this);
        }
        SharedPreferences settings = this.getSharedPreferences(TAG, 0);
        this.isEnabled = true;
        this.isDebugging = settings.getBoolean("debug", false);
        this.distanceFilter = Float.valueOf(settings.getFloat("distanceFilter", 50.0f));
        this.desiredAccuracy = settings.getInt("desiredAccuracy", 10);
        this.locationUpdateInterval = settings.getInt("locationUpdateInterval", 30000);
        this.minimumActivityRecognitionConfidence = settings.getInt("minimumActivityRecognitionConfidence", 80);
        this.fastestLocationUpdateInterval = settings.getInt("fastestLocationUpdateInterval", 5000);
        this.activityRecognitionInterval = settings.getLong("activityRecognitionInterval", 60000L);
        this.stopAfterElapsedMinutes = settings.getInt("stopAfterElapsedMinutes", 0);
        this.stopTimeout = settings.getLong("stopTimeout", 0L);
        this.stopOnTerminate = settings.getBoolean("stopOnTerminate", true);
        this.forceReload = settings.getBoolean("forceReload", false);
        this.isMoving = settings.getBoolean("isMoving", false);
        if (this.stopAfterElapsedMinutes > 0) {
            this.stopUpdatingLocationAt = new Date(System.currentTimeMillis() + (long)(this.stopAfterElapsedMinutes * 60 * 1000));
        }
        this.url = settings.getString("url", null);
        this.batchSync = settings.getBoolean("batchSync", false);
        this.autoSync = settings.getBoolean("autoSync", true);
        if (settings.contains("params")) {
            try {
                this.params = new JSONObject(settings.getString("params", "{}"));
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)"- Faile to parse #params to JSONObject");
            }
        }
        if (settings.contains("headers")) {
            try {
                this.headers = new JSONObject(settings.getString("headers", "{}"));
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)"- Failed to parse #headers to JSONObject");
            }
        }
        Log.i((String)TAG, (String)"----------------------------------------");
        Log.i((String)TAG, (String)"- Start BackgroundGeolocationService");
        Log.i((String)TAG, (String)("  debug: " + this.isDebugging));
        Log.i((String)TAG, (String)("  distanceFilter: " + this.distanceFilter));
        Log.i((String)TAG, (String)("  desiredAccuracy: " + this.desiredAccuracy));
        Log.i((String)TAG, (String)("  locationUpdateInterval: " + this.locationUpdateInterval));
        Log.i((String)TAG, (String)("  fastestLocationUpdateInterval: " + this.fastestLocationUpdateInterval));
        Log.i((String)TAG, (String)("  activityRecognitionInterval: " + this.activityRecognitionInterval));
        Log.i((String)TAG, (String)("  minimumActivityRecognitionConfidence: " + this.minimumActivityRecognitionConfidence));
        Log.i((String)TAG, (String)("  stopTimeout: " + this.stopTimeout));
        Log.i((String)TAG, (String)("  stopOnTerminate: " + this.stopOnTerminate));
        Log.i((String)TAG, (String)("  forceReload: " + this.forceReload));
        Log.i((String)TAG, (String)("  isMoving: " + this.isMoving));
        Log.i((String)TAG, (String)("  url: " + this.url));
        Log.i((String)TAG, (String)("  batchSync: " + this.batchSync));
        Log.i((String)TAG, (String)("  autoSync: " + this.autoSync));
        if (this.stopAfterElapsedMinutes > 0) {
            Log.i((String)TAG, (String)("  stopAfterElapsedMinutes: " + this.stopAfterElapsedMinutes));
        }
        Log.i((String)TAG, (String)"----------------------------------------");
        if (this.isDebugging.booleanValue()) {
            this.toneGenerator = new ToneGenerator(5, 100);
        }
        if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this) == 0) {
            Log.i((String)TAG, (String)"- Connecting to GooglePlayServices...");
            this.googleApiClient = new GoogleApiClient.Builder((Context)this).addApi(LocationServices.API).addApi(ActivityRecognition.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
            this.googleApiClient.connect();
        } else {
            Log.e((String)TAG, (String)"- GooglePlayServices unavailable");
        }
        this.locationDAO = new SQLiteLocationDAO(this.getApplicationContext());
        this.locationDAO.prune(this.maxDaysToPersist);
        this.lastPrunedAt = Calendar.getInstance();
        return this.stopOnTerminate != false ? 2 : 1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onConnectionFailed(ConnectionResult arg0) {
    }

    public void onConnected(Bundle arg0) {
        Log.i((String)TAG, (String)"- GooglePlayServices connected");
        Intent arsIntent = new Intent((Context)this, ActivityRecognitionService.class);
        this.activityRecognitionPI = PendingIntent.getService((Context)this, (int)0, (Intent)arsIntent, (int)0x8000000);
        Intent locationIntent = new Intent((Context)this, LocationService.class);
        this.locationUpdatePI = PendingIntent.getService((Context)this, (int)0, (Intent)locationIntent, (int)0x8000000);
        this.setPace(this.isMoving);
        if (this.googleApiClient.isConnected()) {
            this.requestActivityUpdates();
        }
    }

    public void onEventMainThread(Bundle event) {
        if (event.containsKey("response")) {
            return;
        }
        String name = event.getString("name");
        if (ACTION_GET_LOCATIONS.equalsIgnoreCase(name)) {
            Bundle response = new Bundle();
            response.putString("name", name);
            response.putBoolean("response", true);
            List<TSLocation> rs = this.locationDAO.all();
            JSONArray data = new JSONArray();
            for (TSLocation location : rs) {
                data.put((Object)location.json);
            }
            response.putString("data", data.toString());
            EventBus.getDefault().post((Object)response);
        } else if (ACTION_SET_PACE.equalsIgnoreCase(name)) {
            this.setPace(event.getBoolean("isMoving"));
        } else if (ACTION_SYNC.equalsIgnoreCase(name)) {
            Bundle response = new Bundle();
            response.putString("name", name);
            response.putBoolean("response", true);
            response.putBoolean("success", false);
            response.putString("message", "");
            if (this.url != null) {
                if (this.isNetworkAvailable()) {
                    List<TSLocation> rs = this.locationDAO.allWithLocking();
                    JSONArray data = new JSONArray();
                    if (!rs.isEmpty()) {
                        this.schedulePostLocations(rs);
                        for (TSLocation location : rs) {
                            data.put((Object)location.json);
                        }
                    }
                    response.putString("data", data.toString());
                    response.putBoolean("success", true);
                } else {
                    response.putString("message", "No network connection");
                }
            } else {
                List<TSLocation> rs = this.locationDAO.all();
                this.locationDAO.destroyAll(rs);
                JSONArray data = new JSONArray();
                if (!rs.isEmpty()) {
                    for (TSLocation location : rs) {
                        data.put((Object)location.json);
                    }
                }
                response.putString("data", data.toString());
                response.putBoolean("success", true);
            }
            EventBus.getDefault().post((Object)response);
        }
    }

    public void onEventMainThread(PaceChangeEvent event) {
        this.setPace(event.isMoving);
    }

    public void onEventMainThread(ActivityRecognitionResult result) {
        boolean initialState;
        Date now;
        this.currentActivity = result.getMostProbableActivity();
        String activityName = BackgroundGeolocationService.getActivityName(this.currentActivity.getType());
        int confidence = this.currentActivity.getConfidence();
        Log.i((String)TAG, (String)("- Activity received: " + activityName + ", confidence: " + confidence));
        if (this.stopUpdatingLocationAt != null && (now = new Date(result.getTime())).after(this.stopUpdatingLocationAt)) {
            Log.i((String)TAG, (String)"- Elapsed minutes has expired.  Stopping service");
            this.stopUpdatingLocationAt = null;
            this.stopSelf();
            return;
        }
        if (!this.isMainActivityActive().booleanValue() && this.stopOnTerminate.booleanValue()) {
            this.stopSelf();
            return;
        }
        boolean wasMoving = this.isMoving;
        boolean nowMoving = false;
        switch (this.currentActivity.getType()) {
            case 0: {
                nowMoving = true;
                break;
            }
            case 1: {
                nowMoving = true;
                break;
            }
            case 2: {
                nowMoving = true;
                break;
            }
            case 8: {
                nowMoving = true;
                break;
            }
            case 7: {
                nowMoving = true;
                break;
            }
            case 3: {
                nowMoving = false;
                break;
            }
            case 4: 
            case 5: {
                return;
            }
        }
        boolean startedMoving = !wasMoving && nowMoving;
        boolean justStopped = wasMoving && !nowMoving;
        boolean bl = initialState = !nowMoving && this.stationaryLocation == null;
        if (justStopped && this.stopTimeout > 0L && this.stoppedAt == 0L) {
            this.stoppedAt = result.getElapsedRealtimeMillis();
            return;
        }
        if (!nowMoving && this.stoppedAt > 0L) {
            long elapsedMillis = result.getElapsedRealtimeMillis() - this.stoppedAt;
            long elapsedMinutes = TimeUnit.MILLISECONDS.toMinutes(elapsedMillis);
            Log.i((String)TAG, (String)("- Waiting for stopTimeout (" + this.stopTimeout + " min): elapsed min: " + elapsedMinutes));
            if (elapsedMinutes >= this.stopTimeout) {
                justStopped = true;
            } else {
                return;
            }
        }
        this.stoppedAt = 0L;
        if ((startedMoving || justStopped || initialState) && confidence >= this.minimumActivityRecognitionConfidence) {
            if (justStopped && this.url != null && this.autoSync.booleanValue() && this.isNetworkAvailable()) {
                this.schedulePostLocations(this.locationDAO.allWithLocking());
            }
            this.setPace(nowMoving);
        }
    }

    public void onEventMainThread(Location location) {
        Calendar now;
        long daysSincePrune;
        if (location instanceof StationaryLocation) {
            return;
        }
        Log.i((String)TAG, (String)("BUS Rx:" + location.toString()));
        this.startTone("beep");
        if (!this.isMainActivityActive().booleanValue() && this.forceReload.booleanValue()) {
            this.forceMainActivityReload();
        }
        this.persistLocation(location);
        if (this.url != null && this.autoSync.booleanValue() && this.isNetworkAvailable()) {
            this.schedulePostLocations(this.locationDAO.allWithLocking());
        }
        if ((daysSincePrune = ((now = Calendar.getInstance()).getTimeInMillis() - this.lastPrunedAt.getTimeInMillis()) / 86400000L) >= 1L) {
            this.locationDAO.prune(this.maxDaysToPersist);
            this.lastPrunedAt = now;
        }
    }

    private void setPace(Boolean moving) {
        Log.i((String)TAG, (String)("- setPace: " + moving));
        boolean wasMoving = this.isMoving;
        this.isMoving = moving;
        if (moving.booleanValue() && this.isEnabled.booleanValue()) {
            if (!wasMoving) {
                this.startTone("doodly_doo");
            }
            this.stationaryLocation = null;
            this.requestLocationUpdates();
        } else {
            this.removeLocationUpdates();
            if (this.stationaryLocation == null) {
                this.startTone("long_beep");
                this.stationaryLocation = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
                if (this.stationaryLocation != null) {
                    EventBus.getDefault().post((Object)new StationaryLocation(this.stationaryLocation));
                }
            }
        }
    }

    private Integer translateDesiredAccuracy(Integer accuracy) {
        switch (accuracy) {
            case 1000: {
                accuracy = 105;
                break;
            }
            case 100: {
                accuracy = 104;
                break;
            }
            case 10: {
                accuracy = 102;
                break;
            }
            case 0: {
                accuracy = 100;
                break;
            }
            default: {
                accuracy = 102;
            }
        }
        return accuracy;
    }

    private Integer getLocationUpdateInterval() {
        SharedPreferences settings = this.getSharedPreferences(TAG, 0);
        return settings.getInt("locationUpdateInterval", this.locationUpdateInterval.intValue());
    }

    private Integer getFastestLocationUpdateInterval() {
        return this.fastestLocationUpdateInterval;
    }

    public static String getActivityName(int activityType) {
        switch (activityType) {
            case 0: {
                return "in_vehicle";
            }
            case 1: {
                return "on_bicycle";
            }
            case 2: {
                return "on_foot";
            }
            case 8: {
                return "running";
            }
            case 7: {
                return "walking";
            }
            case 3: {
                return "still";
            }
            case 4: {
                return "unknown";
            }
            case 5: {
                return "tilting";
            }
        }
        return "unknown";
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    private boolean persistLocation(Location location) {
        if (this.locationDAO.persist(BackgroundGeolocationService.locationToJson(location, this.currentActivity))) {
            return true;
        }
        Log.w((String)TAG, (String)("INSERT FAILURE" + location));
        return false;
    }

    private void schedulePostLocations(List<TSLocation> rs) {
        PostLocationTask task = new PostLocationTask();
        task.setBatchMode(this.batchSync);
        task.setRecords(rs);
        Log.d((String)TAG, (String)("- beforeexecute " + task.getStatus()));
        if (Build.VERSION.SDK_INT >= 11) {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
        } else {
            task.execute(new Object[0]);
        }
        Log.d((String)TAG, (String)("- afterexecute " + task.getStatus()));
    }

    private boolean doBatchPost(JSONArray data) {
        try {
            this.params.put("location", (Object)data);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpPost request = this.createHttpRequest();
            Log.d((String)TAG, (String)("POST batch (" + data.length() + " records)"));
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            Log.d((String)TAG, (String)("RESPONSE received: " + response.getStatusLine()));
            return this.handleResponse(response);
        }
        catch (Throwable e) {
            Log.w((String)TAG, (String)("EXCEPTION posting location: " + e));
            e.printStackTrace();
            return false;
        }
    }

    private boolean doPost(JSONObject data) {
        try {
            this.params.put("location", (Object)data);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpPost request = this.createHttpRequest();
            Log.d((String)TAG, (String)("POST " + data.getString("timestamp")));
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            Log.d((String)TAG, (String)("RESPONSE received: " + data.getString("timestamp") + ", " + response.getStatusLine()));
            return this.handleResponse(response);
        }
        catch (Throwable e) {
            Log.w((String)TAG, (String)("EXCEPTION posting location: " + e));
            e.printStackTrace();
            return false;
        }
    }

    private HttpPost createHttpRequest() {
        try {
            this.params.put("device_id", (Object)Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"android_id"));
            HttpPost request = new HttpPost(this.url);
            StringEntity se = new StringEntity(this.params.toString());
            request.setEntity((HttpEntity)se);
            request.setHeader("Accept", "application/json");
            request.setHeader("Content-type", "application/json");
            Iterator keys = this.headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key == null) continue;
                request.setHeader(key, this.headers.getString(key));
            }
            return request;
        }
        catch (Throwable e) {
            Log.w((String)TAG, (String)("EXCEPTION posting location: " + e));
            e.printStackTrace();
            return null;
        }
    }

    private boolean handleResponse(HttpResponse response) {
        switch (response.getStatusLine().getStatusCode()) {
            case 200: 
            case 201: 
            case 204: {
                return true;
            }
            case 404: 
            case 500: {
                return false;
            }
        }
        return false;
    }

    private Boolean isMainActivityActive() {
        SharedPreferences settings = this.getSharedPreferences(TAG, 0);
        return settings.getBoolean("activityIsActive", false);
    }

    private void forceMainActivityReload() {
        Log.w((String)TAG, (String)"- Forcing main-activity reload");
        PackageManager pm = this.getPackageManager();
        Intent launchIntent = pm.getLaunchIntentForPackage(this.getApplicationContext().getPackageName());
        launchIntent.addFlags(4);
        launchIntent.addFlags(262144);
        launchIntent.addFlags(65536);
        this.startActivity(launchIntent);
    }

    private void requestActivityUpdates() {
        Log.i((String)TAG, (String)("- requesting activity updates " + this.activityRecognitionInterval));
        SharedPreferences settings = this.getSharedPreferences(TAG, 0);
        ActivityRecognition.ActivityRecognitionApi.requestActivityUpdates(this.googleApiClient, settings.getLong("activityRecognitionInterval", this.activityRecognitionInterval), this.activityRecognitionPI);
    }

    private void removeActivityUpdates() {
        ActivityRecognition.ActivityRecognitionApi.removeActivityUpdates(this.googleApiClient, this.activityRecognitionPI);
    }

    private void requestLocationUpdates() {
        if (!this.isPaused.booleanValue() || !this.isEnabled.booleanValue()) {
            return;
        }
        SharedPreferences settings = this.getSharedPreferences(TAG, 0);
        this.locationRequest = LocationRequest.create().setPriority(this.translateDesiredAccuracy(settings.getInt("desiredAccuracy", this.desiredAccuracy.intValue())).intValue()).setInterval((long)this.getLocationUpdateInterval().intValue()).setFastestInterval((long)this.getFastestLocationUpdateInterval().intValue()).setSmallestDisplacement(settings.getFloat("distanceFilter", this.distanceFilter.floatValue()));
        LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.locationRequest, this.locationUpdatePI);
    }

    private void removeLocationUpdates() {
        LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, this.locationUpdatePI);
    }

    private void startTone(String name) {
        int tone = 0;
        int duration = 1000;
        if (name.equals("beep")) {
            tone = 24;
        } else if (name.equals("beep_beep_beep")) {
            tone = 41;
        } else if (name.equals("long_beep")) {
            tone = 97;
        } else if (name.equals("doodly_doo")) {
            tone = 86;
        } else if (name.equals("chirp_chirp_chirp")) {
            tone = 93;
        } else if (name.equals("dialtone")) {
            tone = 23;
        }
        if (this.isDebugging.booleanValue()) {
            this.toneGenerator.startTone(tone, duration);
        }
    }

    public void onConnectionSuspended(int arg0) {
    }

    public void onDestroy() {
        Log.w((String)TAG, (String)"- Destroy service");
        this.cleanUp();
        super.onDestroy();
    }

    private void cleanUp() {
        instance = null;
        EventBus.getDefault().unregister((Object)this);
        if (this.googleApiClient != null && this.googleApiClient.isConnected()) {
            this.removeActivityUpdates();
            this.removeLocationUpdates();
            this.googleApiClient.disconnect();
        }
    }

    public static JSONObject locationToJson(Location l, DetectedActivity activity) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        dateFormatter.setTimeZone(tz);
        try {
            JSONObject data = new JSONObject();
            JSONObject coordData = new JSONObject();
            JSONObject activityData = new JSONObject();
            coordData.put("latitude", l.getLatitude());
            coordData.put("longitude", l.getLongitude());
            coordData.put("accuracy", (double)l.getAccuracy());
            coordData.put("speed", (double)l.getSpeed());
            coordData.put("heading", (double)l.getBearing());
            coordData.put("altitude", l.getAltitude());
            if (activity != null) {
                activityData.put("type", (Object)BackgroundGeolocationService.getActivityName(activity.getType()));
                activityData.put("confidence", activity.getConfidence());
                data.put("activity", (Object)activityData);
            }
            data.put("coords", (Object)coordData);
            data.put("timestamp", (Object)dateFormatter.format(l.getTime()));
            return data;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"could not parse location");
            return null;
        }
    }

    public static class PaceChangeEvent {
        public boolean isMoving;

        public PaceChangeEvent(boolean moving) {
            this.isMoving = moving;
        }
    }

    public static class PausedEvent {
        public boolean isPaused;

        public PausedEvent(boolean paused) {
            this.isPaused = paused;
        }
    }

    private class PostLocationTask
    extends AsyncTask<Object, Integer, Boolean> {
        private Boolean batchMode = false;
        private List<TSLocation> records = null;

        private PostLocationTask() {
        }

        public void setBatchMode(Boolean mode) {
            this.batchMode = mode;
        }

        public void setRecords(List<TSLocation> _records) {
            this.records = _records;
        }

        protected Boolean doInBackground(Object ... objects) {
            Log.d((String)BackgroundGeolocationService.TAG, (String)"Executing PostLocationTask#doInBackground");
            if (this.batchMode.booleanValue()) {
                JSONArray rs = new JSONArray();
                for (TSLocation location : this.records) {
                    rs.put((Object)location.json);
                }
                if (BackgroundGeolocationService.this.doBatchPost(rs)) {
                    BackgroundGeolocationService.this.locationDAO.destroyAll(this.records);
                }
            } else {
                boolean remoteOK = true;
                for (TSLocation location : this.records) {
                    if (remoteOK) {
                        remoteOK = BackgroundGeolocationService.this.doPost(location.json);
                    }
                    if (remoteOK) {
                        location.destroy();
                        continue;
                    }
                    Log.d((String)BackgroundGeolocationService.TAG, (String)("- POST FAILURE:  unlocking " + location.id));
                    location.unlock();
                }
            }
            return true;
        }

        protected void onPostExecute(Boolean result) {
            Log.d((String)BackgroundGeolocationService.TAG, (String)"PostLocationTask#onPostExecture");
        }
    }

    public class StationaryLocation
    extends Location {
        public StationaryLocation(Location l) {
            super(l);
        }
    }
}

