(function() {
    'use strict';
    /**********************************************************************
     * Login controller
     **********************************************************************/

    mobileApp.controller('DashboardCtrl', ['$scope', '$rootScope', '$http', '$location', 'Surveys', '$ionicActionSheet','WebSqlDbService', DashboardCtrl]);
    function DashboardCtrl($scope, $rootScope, $http, $location, Surveys, $ionicActionSheet,WebSqlDbService) {
        var objModel = Surveys;
        $rootScope.tabbed = 'recent';
        $rootScope.TitleTop = 'LIST SURVEY';
        $scope.numPerPage = 30;
        $scope.currentPage = 1;

        $scope.rightButtons = [{
            type: 'button-positive',
            content: '<i class="icon ion-log-out"></i>',
            tap: function(e) {
                $rootScope.logout();
            }
        }];

        if(!window.localStorage.resetData) {
            alert('Proses reset data, anda akan di arahkan untuk melakukan login kembali.');
            console.log(window.localStorage);
            window.localStorage.clear();
            window.localStorage.setItem('resetData', 1);
            $rootScope.logout(); return;
        }

        WebSqlDbService.cektable("user", 
            function(r){ 
                console.log(r.available);
                if(!r.available) {
                    $location.path('/login');
                    $rootScope.$apply(); return;
                } 
            }
        )
        if($rootScope.tokenLocal) {
            var url = $rootScope.loginUrl + '/check/token/' + $rootScope.tokenLocal;
            $http({
                url     : url,
                method  : 'POST',
                headers : {'Content-Type': 'application/x-www-form-urlencoded'}
            }).success(function(data, status) {
                if(!data.status){
                    $rootScope.logout(); return;
                }
            })
        }

        var init = 0;
        $scope.setPage = function(cache) {
            var join   = [];
            join[0]    = 'customer';
            join[1]    = 'form';
            var params = {
                "page"  : $scope.currentPage,
                "limit" : $scope.numPerPage,
                "token" : $rootScope.tokenLocal,
                'filter': {'survey_status': '"in progress","on mobile";in'},
                'join': join
            };
            $rootScope.show();
            objModel.getAll(params, function(res) {
                $scope.list = res;
                $scope.nums = _.size(res);
                $scope.noOfPages = Math.ceil(res.numrows / res.listperpage);
                $scope.totalItem = Math.ceil(res.numrows);
                $rootScope.hide();
            }, cache);
        };
        $scope.$watch('currentPage', $scope.setPage(true));
        $scope.onRefresh = function() {
            // Load content
            $scope.setPage(false);
            // Trigger refresh complete on the pull to refresh action
            $scope.$broadcast('scroll.refreshComplete');
            $rootScope.nums = 0;
            $rootScope.task = 0;

        };
        $rootScope.$on('refreshTask', function(notification) {
            $scope.onRefresh();
        });
        $scope.$broadcast('scroll.resize');

        $scope.showmenu = function(item) {

            $ionicActionSheet.show({
                // The various non-destructive button choices
                buttons: [{
                    text: 'Detail'
                }, {
                    text: 'Process'
                }, {
                    text: 'Comment'
                }, {
                    text: 'Route'
                }, ],

                // The text of the red destructive button
                // destructiveText: 'Delete',

                // The title text at the top
                titleText: 'Choose Action ' + item.customer[0].name,

                // The text of the cancel button
                cancelText: 'Cancel',

                // Called when the sheet is cancelled, either from triggering the
                // cancel button, or tapping the backdrop, or using escape on the keyboard
                cancel: function() {},

                // Called when one of the non-destructive buttons is clicked, with
                // the index of the button that was clicked. Return
                // "true" to tell the action sheet to close. Return false to not close.
                buttonClicked: function(index) {
                    if (index === 0) $location.path('customer/' + item.uid);
                    if (index === 1) $location.path('survey/' + item.uid);
                    if (index === 2) $location.path('comment/' + item.assignment_uid + "/1");
                    if(index===3) $location.path('route/'+item.uid);
                    return true;
                },

                // Called when the destructive button is clicked. Return true to close the
                // action sheet. False to keep it open
                destructiveButtonClicked: function() {
                    return true;
                }
            });
        };

        $scope.holdSurvey = function(dt){
            console.log(dt);
            var conf = confirm('Yakin akan menunda survey ini ?');
            if(conf){
                
            }
        }
    };
})();

(function() {
    'use strict';
    /**********************************************************************
     * Login controller
     **********************************************************************/

    mobileApp.controller('HistoryCtrl', ['$scope', '$rootScope', '$http', '$location', 'Surveys', '$stateParams', '$ionicActionSheet', HistoryCtrl]);

    function HistoryCtrl($scope, $rootScope, $http, $location, Surveys, $stateParams, $ionicActionSheet) {
        var objModel = Surveys;
        $scope.tabbed = 'recent';
        $rootScope.TitleTop = 'LIST SURVEY';
        $scope.numPerPage = 30;
        $scope.currentPage = 1;

        $scope.rightButtons = [{
            type: 'button-positive',
            content: '<i class="icon ion-log-out"></i>',
            tap: function(e) {
                $rootScope.logout();
            }
        }];

        var init = 0;
        var join = [];


        $scope.setPage = function(cache) {
            $rootScope.show();
            if ($stateParams.id) {
                join[1] = 'form';
                join[2] = 'customer';
                join[3] = 'survey';

                $scope.surveys = Surveys.getAll({
                    'obj': 'mmassign',
                    'join': join,
                    'filter[uid]': $stateParams.id,
                    "token": $rootScope.tokenLocal
                }, function(data) {
                    $scope.survey = data[0];

                    $scope.forms = JSON.parse(data[0].form[0].data_form);
                    $scope.form_name = data[0].form[0].name;

                    var dataform  = [];
                    angular.forEach($scope.forms, function(_v, _k) {
                        angular.forEach(_v, function(v, k) {
                            dataform.push(v);
                        });
                    });
                    $scope.dataform  = dataform;

                    $scope.value = JSON.parse(data[0].client_data);
                    console.log($scope.forms);
                    console.log($scope.dataform);
                    $rootScope.hide();
                }, cache);

            } else {
                join[0] = 'customer';
                join[1] = 'survey';
                var params = {
                    "page": $scope.currentPage,
                    "limit": $scope.numPerPage,
                    "token": $rootScope.tokenLocal,
                    'filter': {
                        'survey_status': '"canceled","finished";in'
                    },
                    'order': {
                        0: 'date_change desc'
                    },
                    'obj': 'mmassign',
                    'join': join
                };
                objModel.getAll(params, function(res) {
                    $scope.list = res;
                    console.log(res);

                    /*
                    res.forEach(function(n,k){
                        console.log(n);
                        if(n.mmassign_date_uploaded) {
                        var now  = moment(n.mmassign_date_uploaded).format('DD/MM/YYYY HH:mm:ss')
                        var then = moment(n.mmassign_crdate).format('DD/MM/YYYY HH:mm:ss')
                        var ms   = moment(now).diff(moment(then));
                        var d    = moment.duration(ms);
                        var s    = Math.floor(d.asHours()) + moment.utc(ms).format(":mm:ss");
                        $scope.l[k].duration = s;
                        }
                    })*/

                    for (var key in res) {
                        var n = res[key];
                        
                        if(n.date_uploaded) {
                        var now  = moment(n.date_uploaded).format('DD/MM/YYYY HH:mm:ss')
                        var then = moment(n.date_assign).format('DD/MM/YYYY HH:mm:ss')
                        var s    = moment.utc(moment(now,"DD/MM/YYYY HH:mm:ss").diff(moment(then,"DD/MM/YYYY HH:mm:ss"))).format("HH:mm:ss");

                        $scope.list[key].duration = s;
                        console.log(now);
                        console.log(then);
                        console.log(s);
                        console.log(key);
                        }
                    }

                    console.log($scope.list);

                    $scope.noOfPages = Math.ceil(res.numrows / res.listperpage);
                    $scope.totalItem = Math.ceil(res.numrows);
                    $rootScope.hide();
                }, cache);
            }

        };
        $scope.$watch('currentPage', $scope.setPage(true));
        $scope.onRefresh = function() {
            $scope.setPage(false);
            $scope.$broadcast('scroll.refreshComplete');

        };
        $scope.$broadcast('scroll.resize');
        $scope.showmenu = function(item) {

            $ionicActionSheet.show({
                // The various non-destructive button choices
                buttons: [{
                    text: 'Result'
                }, {
                    text: 'Comment'
                }, ],

                // The text of the red destructive button
                // destructiveText: 'Delete',

                // The title text at the top
                titleText: 'Choose Action ' + item.customer[0].name,

                // The text of the cancel button
                cancelText: 'Cancel',

                // Called when the sheet is cancelled, either from triggering the
                // cancel button, or tapping the backdrop, or using escape on the keyboard
                cancel: function() {},

                // Called when one of the non-destructive buttons is clicked, with
                // the index of the button that was clicked. Return
                // "true" to tell the action sheet to close. Return false to not close.
                buttonClicked: function(index) {
                    //console.log(index);
                    if (index === 0) $location.path('historydetail/' + item.uid);
                    if (index === 1) $location.path('comment/' + item.uid);
                    return true;
                },

                // Called when the destructive button is clicked. Return true to close the
                // action sheet. False to keep it open
                destructiveButtonClicked: function() {
                    return true;
                }
            });
        };
    };
})();

(function() {
    'use strict';
    /**********************************************************************
     * Comment controller
     **********************************************************************/

    mobileApp.controller('CommentCtrl', ['$scope', '$rootScope', '$timeout', '$http', '$location', '$anchorScroll', '$ionicFrostedDelegate', '$ionicScrollDelegate', 'Surveys', '$stateParams', CommentCtrl]);
    function CommentCtrl($scope, $rootScope, $timeout, $http, $location, $anchorScroll, $ionicFrostedDelegate, $ionicScrollDelegate, Surveys, $stateParams) {

        var objModel = Surveys;
        $scope.tabbed = 'recent';
        $rootScope.TitleTop = 'LIST SURVEY';
        $scope.numPerPage = 30;
        $scope.currentPage = 1;

        $scope.rightButtons = [{
            type: 'button-positive',
            content: '<i class="icon ion-log-out"></i>',
            tap: function(e) {
                $rootScope.logout();
            }
        }];

        var init = 0;
        var join = [];
        $scope.setPage = function() {
            $rootScope.show();
            if ($stateParams.id) {
                join[1] = 'form';
                join[2] = 'customer';
                join[3] = 'survey';
                join[4] = 'employee';

                $scope.surveys = Surveys.getComment({
                    'join'       : join,
                    'filter[uid]': $stateParams.id,
                    "token"      : $rootScope.tokenLocal
                }, function(data) {
                    $scope.mm = data[0];
                    $scope.form_name = data[0].form[0].name;
                    $scope.survey = data[0].survey[0];
                    $scope.employee = data[0].employee[0];
                    $scope.baseUrl = $rootScope.baseUrl;

                    $scope.list = _.indexBy(data[0].comments, 'datetime');
                    //console.log($scope.list);
                    var menu = {};
                    if ($stateParams.ac) {
                        menu.top = {
                            link: ""
                        };
                        menu.bottom = {
                            title: "Detail",
                            link: "customer/" + $scope.survey.uid
                        };
                    } else {
                        menu.top = {
                            link: "history"
                        };
                        menu.bottom = {
                            title: "Result",
                            link: "historydetail/" + $scope.mm.uid
                        };
                    };
                    $scope.menu = menu;
                    $rootScope.hide();
                    $ionicScrollDelegate.resize();
                    $ionicFrostedDelegate.update();
                    $timeout(function() {
                        $ionicScrollDelegate.scrollBottom(true);
                    }, 1);
                });

            } else {

            }

        };
        $scope.$watch('currentPage', $scope.setPage);

        $scope.msg = '';
        $scope.sendMsg = function(m) {
            if (m && m.trim() != '') {
                $scope.msg = "";
                $scope.formComment = "";
                console.log($scope.msg);

                var data = {
                    'assignment_uid': $scope.mm.uid,
                    'datetime': moment().unix(),
                    'message': m,
                    'sender_source': 2,
                    'sender_uid': $scope.mm.employee_uid,
                    'survey_uid': $scope.mm.survey_uid,
                    'supervisor_uid': $scope.mm.supervisor_uid
                };

                var n = _.clone(data);
                n.nama_user = $scope.employee.name;
                $scope.list[data.datetime] = n;

                $timeout(function() {
                    $ionicScrollDelegate.scrollBottom(true);
                }, 1);

                Surveys.postComment(data, $rootScope.tokenLocal, function(r) {});
            }
        };

        $scope.onRefresh = function() {
            $scope.setPage();
            $scope.$broadcast('scroll.refreshComplete');
        };
        $scope.$broadcast('scroll.resize');
    };
})();

(function() {
    'use strict';
    /**********************************************************************
     * Comment controller
     **********************************************************************/

    mobileApp.controller('RouteCtrl', ['$scope', '$rootScope', '$timeout', '$http', '$location', '$anchorScroll', '$ionicFrostedDelegate', '$ionicScrollDelegate', 'Surveys', '$stateParams', RouteCtrl]);
    function RouteCtrl($scope, $rootScope, $timeout, $http, $location, $anchorScroll, $ionicFrostedDelegate, $ionicScrollDelegate, Surveys, $stateParams) {

        angular.extend($scope, {
            center: {
                latitude: -1.6638653165550492, // initial map center latitude
                longitude: 114.40478515625001, // initial map center longitude
            },
            markers: [], // an array of markers,
            zoom: 5, // the zoom level

        });

        $scope.gmap = {};
        var join = [];
        join[0] = 'branch';
        join[1] = 'form';
        join[2] = 'customer';

        $scope.surveys = Surveys.getAll({
            'join': join,
            'filter[uid]': $stateParams.id,
            "token": $rootScope.tokenLocal
        }, function(data) {
            $scope.survey = data[0];
            $scope.form_name = data[0].form[0].name;

            $scope.gmap = {
                fromAddress: $scope.survey.branch[0].address,
                Lon: $scope.survey.branch[0].longitude,
                Lat: $scope.survey.branch[0].latitude,
                streetAddress: $scope.survey.customer[0].kelurahan + " " + $scope.survey.customer[0].kecamatan + " " + ($scope.survey.customer[0].city).replace("Kabupaten ", "").replace("Kota ", ""),
                customerll: {
                    0: $scope.survey.customer[0].latitude,
                    1: $scope.survey.customer[0].longitude
                },
                businessTitle: "Cabang " + $scope.survey.branch[0].city,
                routePosition: {},
                routes: {},
                showError: function(status) {
                    //console.log(status);
                }
            };
        });

    };
})();