/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var app = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },

    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('load', this.onLoad, false);
        document.addEventListener('deviceready', this.onDeviceReady, false);
        document.addEventListener("orientationchange", this.orientationChange, true);
        //document.addEventListener('focusout', function(e) {window.scrollTo(0, 0)});
    },
    onLoad: function() {

    },

    // deviceready Event Handler
    onDeviceReady: function() {

        //console.log('device ready');
        /*angular.element(document).ready(function() {
            angular.bootstrap(document);
        });*/
        document.addEventListener("backbutton", function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log(window.location.hash);
            if (window.location.hash == '#!/login') {
                //console.log('exit app');
                navigator.app.exitApp();
            } else {
                if (window.location.hash == '#!/') {
                    navigator.Backbutton.goHome(function() {
                        console.log("Successfully launched home intent");
                    }, function() {
                        console.log("Error launching home intent");
                    });
                } else {
                    if (window.location.hash == '#!/login') {
                        navigator.app.exitApp();
                    } else if (window.location.hash == '#!/register') {
                        navigator.app.exitApp();
                    } else {
                        navigator.app.backHistory()
                    }

                }
                //console.log('back button history');

            }
        }, false);

        /* check Connection */
        var networkState = navigator.connection.type;

        var states = {};
        states[Connection.UNKNOWN] = 'Unknown connection';
        states[Connection.ETHERNET] = 'Ethernet connection';
        states[Connection.WIFI] = 'WiFi connection';
        states[Connection.CELL_2G] = 'Cell 2G connection';
        states[Connection.CELL_3G] = 'Cell 3G connection';
        states[Connection.CELL_4G] = 'Cell 4G connection';
        states[Connection.NONE] = 'No network connection';
        //alert('status: '+states[networkState]);
        if (states[networkState] === 'No network connection') {
            /*navigator.notification.alert(
			    'No network connection',  
			    function() { 
					// sementara kalo ga ada koneksi di exit
					//navigator.app.exitApp();
				},
			    'Check Connection',           
			    'OK'                 
			);*/
            window.plugins.toast.show(
                'No network connection', 'short',
                'bottom', function(a) {
                    console.log('toast success: ' + a)
                }, function(b) {})
        } else {

            if (states[networkState] === 'WiFi connection') {
                //alert('WiFi');
                useWifi = true;
                window.plugins.toast.show(
                    'You are using WiFi, make sure you are connect to internet', 'short',
                    'bottom', function(a) {
                        console.log('toast success: ' + a)
                    }, function(b) {})
                /*
        		navigator.notification.alert(
				    'You are using WiFi, make sure you are connect to internet',  
				    function() { 
						// sementara kalo ga ada koneksi di exit
						//navigator.app.exitApp();
					},
				    'Check Connection',           
				    'OK'                 
				);*/
                /*$.ajax({
				    url: 'http://www.aksimaya.co.id/are-we-online.gif',
				    type: 'GET',
				    success: function (data) {
				                // Go ahead with you request
				    },
				    error: function (x, y, z) {
				        if (x.status == 0) {
				            alert("Please connect to the internet");
				        }
				       else{
				           alert("Other Error Occured")
				        }
				    }
				});*/
            } else {
                 window.plugins.toast.show(
                   'Using ' + states[networkState],'short',
                    'bottom', function(a) {
                        console.log('toast success: ' + a)
                    }, function(b) {})
            }

        }
        //blom di coba nih
        //angular.element('[ng-controller=NavCtrl]').scope().back();

        // invoke splash screen
        navigator.splashscreen.hide();

        //app.initPushAksimaya();

    },
    orientationChange: function() {
        //console.log('orientation Change euy');
    },
    registerPushAksimayaAndroid: function() {
        var pushNotification = window.plugins.pushNotification;
        pushNotification.register(
            app.successHandler,
            app.errorHandler, {
                "senderID": "988550772341",
                "ecb": "app.onNotificationGCM"
            }
        );
    },
    successHandler: function(result) {
        console.warn(JSON.stringify(['register ID : ', result]));
    },

    errorHandler: function(error) {
        console.warn(JSON.stringify(['failed to register ', error]));
    },
    initPushAksimaya: function() {
        var pushNotification = window.plugins.pushNotification;
        if (device.platform == 'android' || device.platform == 'Android') {
            app.registerPushAksimayaAndroid();
        }
    },
    onNotificationGCM: function(e) {
        //this.setRegid =  'test regid';
        switch (e.event) {
            case 'registered':
                if (e.regid.length > 0) {
                    //alert(e.regid);
                    console.log("regID = " + e.regid);
                    window.localStorage.setItem("regid", e.regid);
                    app.setRegid = e.regid;
                }
                break;

            case 'message':
                if (e.foreground) {
                    // if the notification contains a soundname, play it.
                    //var my_media = new Media("/android_asset/www/"+e.soundname);
                    //my_media.play();
                } else { // otherwise we were launched because the user touched a notification in the notification tray.
                    if (e.coldstart)
                        console.log("coldstart = " + e.coldstart);
                    else
                        console.log("BACKGROUND = " + e.coldstart);
                }
                console.log("messageMSG = " + e.payload.message);
                navigator.notification.alert(e.message);
                console.log("messageMSGCNT = " + e.payload.msgcnt);
                break;
        }
    },
    /*setRegid: function(){
		this.getRegiId();
	}*/
    getRegiId: function() {
        with(this) {
            return 'hasilnya :' + app.setRegid;
        }
        //return 'test';
    }
};
