// Generated by CoffeeScript 1.3.3
(function() {
  var GMapMapController, Helper, app, capitalize,
    __slice = [].slice;

  app = angular.module('gmap', []);

  capitalize = function(str) {
    return str[0].toUpperCase() + str.slice(1);
  };

  Helper = (function() {

    function Helper($parse, scope, elm, attrs, controller) {
      this.$parse = $parse;
      this.scope = scope;
      this.elm = elm;
      this.attrs = attrs;
      this.controller = controller;
    }

    Helper.prototype.bindMapEvents = function(eventsStr, googleObject) {
      var mapEvent, normalizedMapEvent, normalizedMapEvents, _i, _len, _results,
        _this = this;
      normalizedMapEvents = (function() {
        var _i, _len, _ref, _results;
        _ref = eventsStr.split(' ');
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          mapEvent = _ref[_i];
          _results.push(this.attrs.$normalize(mapEvent));
        }
        return _results;
      }).call(this);
      _results = [];
      for (_i = 0, _len = normalizedMapEvents.length; _i < _len; _i++) {
        normalizedMapEvent = normalizedMapEvents[_i];
        if (normalizedMapEvent in this.attrs) {
          _results.push((function(normalizedMapEvent) {
            var getter, gmEventName;
            gmEventName = _this.attrs.$attr[normalizedMapEvent];
            getter = _this.$parse(_this.attrs[normalizedMapEvent]);
            return google.maps.event.addListener(googleObject, gmEventName, function() {
              var evt, params;
              evt = arguments[0], params = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
              getter(_this.scope, {
                $target: googleObject,
                $event: evt,
                $params: params
              });
              if (!_this.scope.$$phase) {
                return _this.scope.$apply();
              }
            });
          })(normalizedMapEvent));
        }
      }
      return _results;
    };

    Helper.prototype.bindMapProperties = function(propertiesStr, googleObject) {
      var bindProp, _i, _len, _ref, _results,
        _this = this;
      _ref = propertiesStr.split(' ');
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        bindProp = _ref[_i];
        if (bindProp in this.attrs) {
          _results.push((function(bindProp, loopLock) {
            var getter, gmEventName, gmGet, gmSet, locked, setter;
            locked = function(fn) {
              if (!loopLock) {
                try {
                  loopLock = true;
                  return fn();
                } finally {
                  loopLock = false;
                }
              }
            };
            gmGet = function(googleObject, propName) {
              var gmGetterName;
              gmGetterName = "get" + (capitalize(propName));
              if (googleObject[gmGetterName]) {
                return googleObject[gmGetterName]();
              } else {
                return googleObject.get(propName);
              }
            };
            gmSet = function(googleObject, propName, value) {
              var gmSetterName;
              gmSetterName = "set" + (capitalize(propName));
              if (googleObject[gmSetterName]) {
                return googleObject[gmSetterName](value);
              } else {
                return googleObject.set(propName, value);
              }
            };
            gmEventName = "" + (bindProp.toLowerCase()) + "_changed";
            getter = _this.$parse(_this.attrs[bindProp]);
            setter = getter.assign;
            _this.scope.$watch(getter, function(value) {
              return locked(function() {
                return gmSet(googleObject, bindProp, value);
              });
            });
            if (setter != null) {
              if (!getter(_this.scope)) {
                locked(function() {
                  setter(_this.scope, gmGet(googleObject, bindProp));
                  if (!_this.scope.$$phase) {
                    return _this.scope.$digest();
                  }
                });
              }
              return google.maps.event.addListener(googleObject, gmEventName, function() {
                return locked(function() {
                  setter(_this.scope, gmGet(googleObject, bindProp));
                  if (!_this.scope.$$phase) {
                    return _this.scope.$digest();
                  }
                });
              });
            }
          })(bindProp, false));
        }
      }
      return _results;
    };

    Helper.prototype.getOpts = function() {
      return angular.extend({}, this.scope.$eval(this.attrs.options));
    };

    Helper.prototype.getMapFromController = function(widget) {
      var _this = this;
      if (this.controller) {
        return this.controller.getMap().then(function(map) {
          var mapAttr;
          widget.setMap(map);
          if (_this.attrs.map) {
            mapAttr = _this.$parse(_this.attrs.map);
            if (mapAttr.setter) {
              return _this.scope.$apply(function() {
                return mapAttr.setter(this.scope, map);
              });
            }
          }
        });
      }
    };

    Helper.prototype.getAttrValue = function(attrName) {
      var value;
      if (this.attrs[attrName]) {
        value = this.$parse(this.attrs[attrName])(this.scope);
      }
      return value;
    };

    Helper.prototype.setAttrValue = function(attrName, value) {
      if (this.attrs[attrName]) {
        return this.$parse(this.attrs[attrName]).assign(this.scope, value);
      }
    };

    Helper.prototype.createOrGetAttrValue = function(attrName, factoryFn) {
      var value;
      value = this.getAttrValue(attrName);
      if (value == null) {
        value = factoryFn();
      }
      this.setAttrValue(attrName, value);
      return value;
    };

    Helper.prototype.createOrGetWidget = function(factoryFn) {
      return this.createOrGetAttrValue('widget', factoryFn);
    };

    return Helper;

  })();

  GMapMapController = (function() {

    function GMapMapController($q) {
      this.map = $q.defer();
    }

    GMapMapController.prototype.setMap = function(map) {
      return this.map.resolve(map);
    };

    GMapMapController.prototype.getMap = function() {
      return this.map.promise;
    };

    return GMapMapController;

  })();

  GMapMapController.$inject = ['$q'];

  app.directive('gmapMap', [
    '$parse', function($parse) {
      var events, properties;
      events = 'bounds_changed center_changed click dblclick drag dragend ' + 'dragstart heading_changed idle maptypeid_changed mousemove mouseout ' + 'mouseover projection_changed resize rightclick tilesloaded tilt_changed ' + 'zoom_changed';
      properties = 'center heading mapTypeId tilt zoom';
      return {
        controller: GMapMapController,
        restrict: 'E',
        compile: function(tElm, tAttrs) {
          var attr, mapDiv, _i, _len, _ref;
          mapDiv = angular.element('<div></div>');
          tElm.prepend(mapDiv);
          _ref = ['class', 'id', 'style'];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            attr = _ref[_i];
            if (!(attr in tAttrs)) {
              continue;
            }
            mapDiv.attr(attr, tAttrs[attr]);
            tElm.removeAttr(attr);
          }
          return {
            pre: function(scope, elm, attrs, controller) {
              var h, opts, widget;
              h = new Helper($parse, scope, elm, attrs, controller);
              opts = h.getOpts();
              widget = h.createOrGetWidget(function() {
                return new google.maps.Map(elm.children()[0], opts);
              });
              controller.setMap(widget);
              h.bindMapEvents(events, widget);
              return h.bindMapProperties(properties, widget);
            }
          };
        }
      };
    }
  ]);

  app.directive('gmapMarker', [
    '$parse', function($parse) {
      var events, properties;
      events = 'animation_changed click clickable_changed cursor_changed ' + 'dblclick drag dragend draggable_changed dragstart flat_changed icon_changed ' + 'mousedown mouseout mouseover mouseup position_changed rightclick ' + 'shadow_changed shape_changed title_changed visible_changed zindex_changed';
      properties = 'animation clickable cursor draggable flat icon map position ' + 'shadow shape title visible zIndex';
      return {
        require: '^?gmapMap',
        restrict: 'E',
        link: function(scope, elm, attrs, controller) {
          var h, opts, widget;
          h = new Helper($parse, scope, elm, attrs, controller);
          opts = h.getOpts();
          widget = h.createOrGetWidget(function() {
            return new google.maps.Marker(opts);
          });
          h.getMapFromController(widget);
          h.bindMapEvents(events, widget);
          h.bindMapProperties(properties, widget);
          scope.$emit('create_marker', widget);
          return scope.$on('$destroy', function() {
            return scope.$emit('destroy_marker', widget);
          });
        }
      };
    }
  ]);

  app.directive('gmapInfoWindow', [
    '$parse', function($parse) {
      var events, properties;
      events = 'closeclick content_change domready position_changed zindex_changed';
      properties = 'content position zindex';
      return {
        restrict: 'E',
        link: function(scope, elm, attrs) {
          var h, opts, widget, _open;
          h = new Helper($parse, scope, elm, attrs);
          elm.css('display', 'none');
          opts = h.getOpts();
          opts.content = elm.children()[0];
          widget = h.createOrGetWidget(function() {
            return new google.maps.InfoWindow(opts);
          });
          h.bindMapEvents(events, widget);
          h.bindMapProperties(properties, widget);
          _open = widget.open;
          return widget.open = function() {
            var args;
            args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
            return _open.call.apply(_open, [widget].concat(__slice.call(args)));
          };
        }
      };
    }
  ]);

  app.directive('gmapStyledMarker', [
    '$parse', function($parse) {
      var events, properties, styleEvents, styleProperties;
      events = 'animation_changed click clickable_changed cursor_changed ' + 'dblclick drag dragend draggable_changed dragstart flat_changed icon_changed ' + 'mousedown mouseout mouseover mouseup position_changed rightclick ' + 'shadow_changed shape_changed title_changed visible_changed zindex_changed';
      properties = 'animation clickable cursor draggable flat icon map position ' + 'shadow shape title visible zIndex';
      styleEvents = 'text_changed color_changed fore_changed starcolor_changed';
      styleProperties = 'text color fore starcolor';
      return {
        require: '^?gmapMap',
        restrict: 'E',
        link: function(scope, elm, attrs, controller) {
          var h, opts, styledIconTypeName, widget;
          h = new Helper($parse, scope, elm, attrs, controller);
          opts = h.getOpts();
          styledIconTypeName = (h.getAttrValue('iconType') || 'marker').toUpperCase();
          opts.styleIcon = h.createOrGetAttrValue('styleIcon', function() {
            return opts.styleIcon || new StyledIcon(StyledIconTypes[styledIconTypeName], {});
          });
          h.bindMapEvents(styleEvents, opts.styleIcon);
          h.bindMapProperties(styleProperties, opts.styleIcon);
          widget = h.createOrGetWidget(function() {
            return new StyledMarker(opts);
          });
          h.getMapFromController(widget);
          h.bindMapEvents(events, widget);
          h.bindMapProperties(properties, widget);
          scope.$emit('create_marker', widget);
          return scope.$on('$destroy', function() {
            return scope.$emit('destroy_marker', widget);
          });
        }
      };
    }
  ]);

  app.directive('gmapInfoBubble', [
    '$parse', function($parse) {
      var events, properties;
      events = 'closeclick content_change domready position_changed zindex_changed';
      properties = 'content position zIndex ' + 'backgroundColor borderColor borderRadius borderWidth padding arrowPosition ' + 'disableAutoPan disableAnimation minWidth maxWidth minHeight maxHeight ' + 'shadowStyle arrowSize arrowStyle arrowPosition' + 'backgroundClassName tabClassName';
      return {
        restrict: 'E',
        link: function(scope, elm, attrs) {
          var h, opts, widget, _open;
          h = new Helper($parse, scope, elm, attrs);
          elm.css('display', 'none');
          opts = h.getOpts();
          opts.content = elm.children()[0];
          widget = h.createOrGetWidget(function() {
            return new InfoBubble(opts);
          });
          h.bindMapEvents(events, widget);
          h.bindMapProperties(properties, widget);
          _open = widget.open;
          return widget.open = function() {
            var args;
            args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
            return _open.call.apply(_open, [widget].concat(__slice.call(args)));
          };
        }
      };
    }
  ]);

  app.directive('gmapMarkerClusterer', [
    '$parse', function($parse) {
      var events, properties;
      events = 'click clusteringbegin clusteringend mouseout mouseover';
      properties = 'averageCenter batchSize batchSizeIE calculator clusterClass ' + 'gridSize ignoreHidden imageExtension imagePath imageSizes maxZoom ' + 'minimumClusterSize printable styles title zoomOnClick';
      return {
        scope: true,
        require: '^?gmapMap',
        restrict: 'E',
        compile: function(tElm, tAttrs) {
          var noDraw, widget;
          noDraw = true;
          widget = void 0;
          return {
            pre: function(scope, elm, attrs, controller) {
              var h, opts;
              h = new Helper($parse, scope, elm, attrs, controller);
              opts = h.getOpts();
              widget = h.createOrGetWidget(function() {
                return new MarkerClusterer(null, [], opts);
              });
              h.getMapFromController(widget);
              h.bindMapEvents(events, widget);
              h.bindMapProperties(properties, widget);
              scope.$on('create_marker', function(event, marker) {
                return widget.addMarker(marker, noDraw);
              });
              return scope.$on('destroy_marker', function(event, marker) {
                return widget.removeMarker(marker, noDraw);
              });
            },
            post: function(scope, elm, attrs, controller) {
              noDraw = false;
              return widget.repaint();
            }
          };
        }
      };
    }
  ]);

}).call(this);