mobileApp.service('WebSqlDbService',['$rootScope','$resource','$window', function($rootScope, $resource, $window) {

//    $rootScope.uidDb = "";
    
    

    function loaddb(uid) {
//        $rootScope.uidDb = uid;
    
        //console.log($rootScope);
        //if ($window && $window.sqlitePlugin) {
        //	return  $window.sqlitePlugin.openDatabase({name:'mobileDB_'+uid});
        //}
        var dbName = 'aksimayaDB';
        return window.openDatabase(dbName, '1.0', 'Mobile DB', 2 * 2024 * 2024);
    }

    this.createDb = function (uid, reset) {
        var db = loaddb(uid);
        $rootScope.mobileDb = db;
    };

    this.createTables = function (reset) {
        var db = loaddb($rootScope.uidDb);
        db.transaction(function (tx) {
            if(reset) {
            tx.executeSql('DROP TABLE IF EXISTS draft'); 
            tx.executeSql('DROP TABLE IF EXISTS user');
            }
            tx.executeSql('CREATE TABLE IF NOT EXISTS user    (uid INTEGER PRIMARY KEY ASC, username TEXT, password TEXT, token TEXT, imei TEXT, last_update TEXT)');
            tx.executeSql('CREATE TABLE IF NOT EXISTS draft   (uid INTEGER PRIMARY KEY ASC, content TEXT, image TEXT, location TEXT, last_update TEXT, last_update_table TEXT)');
        });
    };
    
    this.reset = function () {
        var db = loaddb($rootScope.uidDb);
        db.transaction(function (tx) {
            tx.executeSql('DROP TABLE IF EXISTS draft'); 
            tx.executeSql('DROP TABLE IF EXISTS user');            
        });
    };
    
    this.cektable = function (table, successCallback) 
    {
        var db = loaddb($rootScope.uidDb);
        db.transaction(function (tx) {
            var query = "SELECT count(type) as available from sqlite_master WHERE type = 'table' and name='"+table+"'";
            //console.log(query);
            return tx.executeSql(query, [], 
                function(transaction, results){
                    
                    
                    var len = results.rows.length;
                    var res = {};    
                    if(len) {
                        for(var i=0; i<len; i++){  
                        res[i] = results.rows.item(i);
                        } 
                    }
                    
                    successCallback(res[0]);
                }, errorCB);
        });
    }

    this.execUpdate = function(table, data) {
        var db = loaddb($rootScope.uidDb);
        if (data.uid) {
            db.transaction(function(tx) {
                var query = "SELECT * FROM " + table + " WHERE uid=" + data.uid;
                tx.executeSql(query, [], function(transaction, results) {
                    var len = results.rows.length;
                    if (len) {
                        update(table, data.uid, data);
                    } else {
                        insert(table, data);
                    }
                }, errorCB);
            });
        } else {
            console.log("UID NOT FOUND !!");
        }
    };


    function insert(table, data) {
        var fil = "'last_update',";
        var val = "'" + new Date() + "',";

        if (table != "user") {
            fil += "'last_update_table',";
            val += "'" + new Date() + "',";
        }

        angular.forEach(data, function(v, k) {
            fil += "'" + k + "',";
            val += "'" + v + "',";
        });

        var field = fil.substr(0, fil.length - 1);
        var value = val.substr(0, val.length - 1);
        var db = loaddb($rootScope.uidDb);

        db.transaction(function(tx) {
            var query = "INSERT INTO " + table + " (" + field + ") VALUES (" + value + ")"; //console.log(query);
            tx.executeSql(query, [],
                function(transaction, results) {
                    console.log("SUCCESS Insert data webDB " + table + " uid " + data.uid);
                },
                function(err) {
                    console.log("ERROR Insert data webDB " + table + " uid " + data.uid + " : " + err.code);
                });

        });

        if (table != "user") {
            db.transaction(function(tx) {
                var query = "UPDATE " + table + " SET last_update_table='" + new Date() + "'";
                tx.executeSql(query, [],
                    function(transaction, results) {},
                    function(err) {});
            });
        }
    };

    function update(table, id, data) {
        var fil = "last_update='" + new Date() + "',";
        angular.forEach(data, function(v, k) {
            fil += k + "='" + v + "',";
        });

        var field = fil.substr(0, fil.length - 1);
        var db = loaddb($rootScope.uidDb);

        db.transaction(function(tx) {
            var query = "UPDATE " + table + " SET " + field + " WHERE uid=" + id + " ";
            tx.executeSql(query, [],
                function(transaction, results) {
                    console.log("SUCCESS Update data webDB " + table + " uid " + data.uid);
                },
                function(err) {
                    console.log("ERROR Update data webDB " + table + " uid " + data.uid + " : " + err.code);
                });
        });

        if (table != "user") {
            db.transaction(function(tx) {
                var query = "UPDATE " + table + " SET last_update_table='" + new Date() + "'";
                tx.executeSql(query, [],
                    function(transaction, results) {},
                    function(err) {});
            });
        }
    };

    this.select = function(table, where, successCallback) {

        if (_.isEmpty(where)) $_w = "";
        else {
            var w = "";
            angular.forEach(where, function(v, k) {
                w += k + "='" + v + "' AND ";
            });
            $_w = "WHERE " + w.substr(0, w.length - 4);
        }



        var db = loaddb($rootScope.uidDb);
        db.transaction(function(tx) {
            var query = "SELECT * FROM " + table + " " + $_w;
            //console.log(query);
            return tx.executeSql(query, [], function(transaction, results) {
                successCallback(results);
            }, errorCB);
        });
    }

    this.execDelete = function(table, id, byfield) {
        if (id > 0) {
            var w = byfield ? "WHERE " + byfield + "=" + id : "WHERE uid=" + id;
            var db = loaddb($rootScope.uidDb);
            db.transaction(function(tx) {
                var query = "SELECT * FROM " + table + " " + w;
                tx.executeSql(query, [], function(transaction, results) {
                    var len = results.rows.length;
                    if (len) {
                        var query = "DELETE FROM " + table + " " + w;
                        return tx.executeSql(query, [],
                        function(transaction, results) {
                            console.log("SUCCESS Delete data webDB " + table + " " + id);
                        },
                        function(err) {
                            console.log("ERROR Delete data webDB " + table + " " + id + " : " + err.code);
                        });
                    } else {
                        console.log("Info : Draft not found");
                    }
                }, errorCB);
            });
        } else {
            console.log("UID NOT FOUND !!");
        }
        
    }



    function querySuccess(tx, results) {
        var len = results.rows.length;
        console.log("DEMO table: " + len + " rows found.");
        var res = {};
        for (var i = 0; i < len; i++) {
            //console.log("Row = " + i + " Data =  " + results.rows.item(i).content);
            res[i] = results.rows.item(i).content
        }
        console.log(res);
        return res;
    }

    function errorCB(err) {
        alert("Error processing SQL: " + JSON.stringify(err));
        $rootScope.hide();
    }


}]);