(function() {
    'use strict';
    
    mobileApp.factory('DataApi', ['apiService', '_', 'apiUrl', DataApi]);
    
    function DataApi(apiService, _, apiUrl){
    	var useCache = true;
        return {
            getAll : function (objModel, params, callback, useCacheReq) {

                var chacheMasterName = objModel;
                if (params.obj) {
                    console.log(params.obj);    
                    chacheMasterName = params.obj;
                }

                console.log(useCache);
                var storageCacheByState = window.localStorage.getItem(objModel + '.' + JSON.stringify(params));
                var storageCacheMaster = window.localStorage.getItem(chacheMasterName + '.master');

                if(storageCacheByState && storageCacheMaster && useCache && useCacheReq){
                    console.log(chacheMasterName + '_getAll: from cache..');
                    
                    var cacheByState = JSON.parse(storageCacheByState);
                    var cacheMaster = JSON.parse(storageCacheMaster); //JSON.parse(window.localStorage.getItem(objModel + '.master'));
                    //var masterByUid = JSON.parse(window.localStorage.getItem(objModel + '.byuid')); 
                    
                    console.log({cacheByStateData : cacheByState});
                    console.log({cacheMasterData : cacheMaster});
                    
                    //refresh cacheData dr master data
                    var dataRefresh = [];
                    _.each(cacheByState.data, function(val, key) {
                            //console.log(_.pluck(masterByUid[val.uid], val.uid));
                            //console.log(masterByUid[val.uid]);
                            dataRefresh.push(_.findWhere(cacheMaster.data, {uid: val.uid}));
                    });
                    
                    //reassign ma data yg lebih pres..
                    //cacheByState.data = dataRefresh;
                    //console.log(cacheByState);
                    callback(cacheByState);
                }else{
                   
                    //var urlGET = serialize(dataParams);
                    var urlGET = jQuery.param(params);
                    //console.log(params);
                    apiService.exec('GET', apiUrl + '/' + objModel + '?' + urlGET).then(function(response){
                        console.log(chacheMasterName + '_getAll: from server..');
                        console.log(response);
                        if(useCache){
                            window.localStorage.removeItem(objModel + '.' + JSON.stringify(params));
                        	window.localStorage.setItem(objModel + '.' + JSON.stringify(params), JSON.stringify(response.data));
                        }
                        /*
                        var tmp = JSON.parse(window.localStorage.getItem(objModel + '.master'));
                        if(tmp){
                            _.each(response.data.data, function(key) {
                                if(typeof _.findWhere(tmp.data, {uid: key.uid}) == 'undefined'){
                                    //console.log('add to masterdata');
                                    tmp.data.push(key);
                                }
                            });
                            
                            //update master data
                            if(useCache){
                            window.localStorage.setItem(objModel + '.master', JSON.stringify(tmp));
                            }
                            //var dataByUid = _.indexBy(tmp.data, 'uid');
                            //window.localStorage.setItem(objModel + '.byuid', JSON.stringify(dataByUid)); 
                        }else{
                            // init master data
                            //var dataByUid = _.indexBy(response.data.data, 'uid');
                            //window.localStorage.setItem(objModel + '.byuid', JSON.stringify(dataByUid)); 
                            if(useCache){
                            window.localStorage.setItem(objModel + '.master', JSON.stringify(response.data));
                            }
                        }
                        */


                        var tmp     = JSON.parse(window.localStorage.getItem(chacheMasterName + '.master'));
                        var sizeRet = _.size(tmp);
                        console.log(tmp);

                        function findWithAttr(obj, attr, value) {
                            for(var index in obj) { 
                               if (obj.hasOwnProperty(index)) {
                                   var r = obj[index];
                                   if(r[attr] == value) {
                                    console.log(index, r[attr]);
                                    return index;
                                   }
                               }
                            }
                        }


                        if(tmp){
                            
                            _.each(response.data, function(key) {
                                var check = _.isObject(_.findWhere(tmp, {uid: key.uid}));
                                //console.log(key.uid, tmp, check);
                                if(!check){
                                    sizeRet = sizeRet + 1; 
                                    console.log(sizeRet, 'add to masterdata ', key.uid);
                                    //tmp.push(key);
                                    tmp[sizeRet-1] = key;
                                }
                                else {
                                    var availableIndexData  = findWithAttr(tmp, 'uid', key.uid);
                                    //console.log(key.uid, tmp, availableIndexData, availableData);
                                    tmp[availableIndexData] = key;
                                }
                            });
                            
                            
                            //update master data
                            if(useCache){
                            window.localStorage.removeItem(chacheMasterName + '.master');
                            window.localStorage.setItem(chacheMasterName + '.master', JSON.stringify(tmp));
                            }
                            //var dataByUid = _.indexBy(tmp.data, 'uid');
                            //window.localStorage.setItem(objModel + '.byuid', JSON.stringify(dataByUid)); 
                        }else{
                            // init master data
                            //var dataByUid = _.indexBy(response.data.data, 'uid');
                            //window.localStorage.setItem(objModel + '.byuid', JSON.stringify(dataByUid)); 
                            if(useCache){
                            window.localStorage.removeItem(chacheMasterName + '.master');    
                            window.localStorage.setItem(chacheMasterName + '.master', JSON.stringify(response.data));
                            }
                        }

                        callback(response.data);
                    });                 
                }
            },            
            getRowByUid : function (objModel, id, callback){
                var result = window.localStorage.getItem(objModel + '.master');
                if(result){
                    console.log(objModel + '_getRow: from cache..');
                    var tmp = JSON.parse(result);
                    
                    // var res = _.findWhere(tmp.data, {uid: id});
                    var res = _.findWhere(tmp, {uid: id});
                    
                    if(!res){
                        apiService.exec('GET', apiUrl + '/' + objModel + '/' + id).then(function(response){
                            //console.log(objModel + '_getRow: from server.. (id not found on cache)');
                            callback(response.data.data);
                        });                         
                    }else{
                        console.log(res);
                        callback(res);
                    }
                    
                }else{
                    apiService.exec('GET', apiUrl + '/' + objModel + '/' + id).then(function(response){
                        console.log(objModel + '_getRow: from server..');
                        callback(response.data.data);
                    });                   
                }
            },
            add: function (objModel, params, callback) {
                clearCache(objModel);
                //console.log(params);
                apiService.exec('POST', apiUrl + '/' + objModel, {data: params}).then(function(response){
                    //console.log("Server Response: " + response.data.status);
                    var result = window.localStorage.getItem(objModel + '.master');
                    
                    if(result){
                        params["uid"] = response.data.newid;
                       
                        
                    }
                    callback(response.data);
                });
            },
            update: function (objModel, uid, params, callback) {
                var result = window.localStorage.getItem(objModel + '.master');
                if(result){            
                    var tmp = JSON.parse(result);
                    
                    //update data
                    _.each(tmp.data, function(val, key){
                        if (tmp.data.hasOwnProperty(key)) {
                            if(tmp.data[key].uid === uid){
                                tmp.data[key] = params;
                            }
                        }                        
                    })
           			if(useCache){
                    window.localStorage.removeItem(objModel + '.master');    
                    window.localStorage.setItem(objModel + '.master', JSON.stringify(tmp));
                   }
                }
                                    
                apiService.exec('PUT', apiUrl + '/' + objModel + '/' + uid, {data: params}).then(function(response){ 
                    //console.log(response);
                    //console.log("Server Response: " + response.data.status);
                    callback(response.data);
                });      
            },
            updateTask: function(objModel, uid, params, callback) {
                var result = window.localStorage.getItem(objModel + '.master');
                if(result){            
                    var tmp = JSON.parse(result);
                    
                    _.each(tmp, function(v,k){
                        if(uid == v.uid) {
                            var cd = new Date();
                            var currDate = cd.getFullYear()+"-"+cd.getMonth()+"-"+cd.getDate()+" "+cd.getHours()+":"+cd.getMinutes()+":"+cd.getSeconds();
                            tmp[k].survey_status = 'in progress';
                            tmp[k].date_status   = currDate;
                            console.log(uid, v.uid, tmp);
                        }
                    });

                    if(useCache){
                     window.localStorage.removeItem(objModel + '.master');       
                     window.localStorage.setItem(objModel + '.master', JSON.stringify(tmp));
                    }
                }
                apiService.exec('POST', apiUrl + '/' + objModel + '/?token='+params.token+'&updateTask=true', params).then(function(response){ 
                    console.log(response);
                    console.log("Server Response: " + response.data.status);
                    callback(response.data);
                });  
            },

            saveSurvey: function(objModel, uid, params, callback) {
                var result = window.localStorage.getItem(objModel + '.master');
                if(result){            
                    var tmp = JSON.parse(result);
                    
                    _.each(tmp, function(v,k){
                        if(uid == v.uid) {
                            delete tmp[k];
                            console.log(uid, v.uid, k, tmp);
                        }
                    });

                    if(useCache){
                     window.localStorage.removeItem(objModel + '.master');       
                     window.localStorage.setItem(objModel + '.master', JSON.stringify(tmp));
                    }
                }
                
                apiService.exec('POST', apiUrl + '/' + objModel + '?token='+params.token+'&saveform=true', params).then(function(response){ 
                    console.log(response);
                    console.log("Server Response: " + response.data.status);
                    callback(response.data);
                });  
                
            },

            holdSurvey: function(objModel, uid, params, callback) {
                var result = window.localStorage.getItem(objModel + '.master');
                if(result){            
                    var tmp = JSON.parse(result);
                    
                    _.each(tmp, function(v,k){
                        if(uid == v.uid) {
                            delete tmp[k];
                            console.log(uid, v.uid, k, tmp);
                        }
                    });

                    if(useCache){
                     window.localStorage.removeItem(objModel + '.master');       
                     window.localStorage.setItem(objModel + '.master', JSON.stringify(tmp));
                    }
                }
                
                apiService.exec('POST', apiUrl + '/' + objModel + '?token='+params.token+'&holdform=true', params).then(function(response){ 
                    console.log(response);
                    console.log("Server Response: " + response.data.status);
                    callback(response.data);
                });  
                
            },
                
            remove: function (objModel, id, params, callback) {
                clearCache(objModel);
                    
                apiService.exec('DELETE', apiUrl + '/' + objModel + '/' + id, {data: params}).then(function(response){              
                    //console.log("Server Response: " + response.data.status);
                    callback(response);
                });
            },
            removeByField: function (objModel, params, callback) {
                var urlGET = jQuery.param(params);
                clearCache(objModel);
                    
                apiService.exec('DELETE', apiUrl + '/' + objModel  + '?' + urlGET).then(function(response){              
                    //console.log("Server Response: " + response.data.status);
                    callback(response);
                }); 

            },
            
            clearCache: function (objModel){
                console.log("Clear cache: " + objModel);
                clearCache(objModel);
            }
            
        };

		function clearCache(objModel){
			console.log(window.localStorage, window.localStorage.length);
			  for (var i = 0; i < window.localStorage.length; i++){
                        var key = window.localStorage.key(i);
                        //console.log('getAll Storage: ' + window.localStorage.key(i));
                        var value = key.split(".");
                        if(value[0] == objModel){
                            console.log('found: ' + window.localStorage.key(i));
                            window.localStorage.removeItem(window.localStorage.key(i));
                        }
                    }
		}
                
        function serialize(obj, prefix){
            var str = [];
            for(var p in obj) {
                var k = prefix ? prefix + "[" + p + "]" : p, v = obj[p];
                str.push(typeof v == "object" ?
                    serialize(v, k) :
                    encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
            return str.join("&");
        }
    };
})();
(function() {
    'use strict';
    mobileApp.factory('dataService', ['$http', '$q', '$cacheFactory', 'jsonObjServices', dataService]);
    
    function dataService($http, $q, $cacheFactory, jsonObjServices) {
        var cache = $cacheFactory('resource');
    
        return {
            get: function(cacheId, endpoint, params) {
                var result = cache.get(cacheId);
                var start = new Date().getTime();
                var deferred = $q.defer();
        
                if(result) {
                    //console.log("cache hit: " + cacheId);
                    deferred.resolve(result);
                    return deferred.promise;
                } else {
                    console.log("cache miss: " + cacheId);
                    
                    $http({method:'GET', url: endpoint, params: params}).success(function (response){
                        //console.log('time taken for request: ' + (new Date().getTime() - start) + 'ms');
                        if(response.error) {
                            //callback(response);
                            return false;
                        }
                        console.log("putting resource in cacheID :" + cacheId);
                        
                        cache.put(cacheId, response);
                        deferred.resolve(response);
                    });
                    
                    return deferred.promise;
                }
            },
            post: function(cacheId, endpoint, params, callback){
                var start = new Date().getTime();
    
                $http.post(endpoint, {data: params}).success(function (response){
                    //console.log('time taken for request: ' + (new Date().getTime() - start) + 'ms');
                    if(response.error) {
                        callback(response);
                        return false;
                    }
                    
                    //cache proses, dilakukan setelah ajax karena mesti dapet newID
                    var cacheValue = cache.get(cacheId + '.all');
                    if(cacheValue){
                        params["uid"] = response.newid;
                        cacheValue.data = jsonObjServices.add(cacheValue.data, params);
                        cacheValue.numrows += 1;
                        cache.put(cacheId + '.all', cacheValue);
                        cache.put(cacheId + '.' + response.newid, {"data": params});
                    }
                    //end cache proses
                    
                    callback(response);
                });     
            },        
            put: function(cacheId, endpoint, params, callback){
                var start = new Date().getTime();
                
                //cache proses, dilakukan sebelum ajax biar keliatan mantabs ui nya
                var modelName = cacheId.split(".");
                var cacheValue = cache.get(modelName[0] + '.all');
                if(cacheValue){
                    cacheValue.data = jsonObjServices.update(cacheValue.data, modelName[1], params);
                    //console.log(cacheValue);
                    cache.put(modelName[0] + '.all', cacheValue);
                }
                //end cache proses
                    
                $http.put(endpoint, {data: params}).success(function (response){
                    //console.log('time taken for request: ' + (new Date().getTime() - start) + 'ms');
                    if(response.error) {
                        callback(response);
                        return false;
                    }
                    callback(response);
                });     
            },
            remove: function(cacheId, endpoint, params, callback){
                var start = new Date().getTime();
                
                //cache proses, dilakukan sebelum ajax biar keliatan mantabs ui nya
                cache.put(cacheId, '{}');
    
                var modelName = cacheId.split(".");
                var cacheValue = cache.get(modelName[0] + '.all');
                if(cacheValue){
                    cacheValue.data = jsonObjServices.remove(cacheValue.data, modelName[1]);
                    cacheValue.numrows -= 1;
                    cache.put(modelName[0] + '.all', cacheValue);
                }
                //end cache proses         
    
                $http.delete(endpoint, params).success(function (response){
                   // console.log('time taken for request: ' + (new Date().getTime() - start) + 'ms');
                    if(response.error) {
                        callback(response);
                        return false;
                    }
                    callback(cacheValue);
                });
            }
        }
    }
})();

(function() {
    'use strict';

    mobileApp.factory('jsonObjServices', [jsonObjServices]);
    
    function jsonObjServices() {
        return{
            //Printing Json Object
            printJson: function (arr){
                //console.log(arr.data);
                for(i=0;i<arr.length;i++) 	{ 		
                    p = arr[i]; 		
                    for (var key in p) { 			
                        if (p.hasOwnProperty(key)) { 			
                           // console.log(key + " -> " + p[key]);
                        }
                    }
                }
            },
             //Adding Element in Json Object
            add: function(arr, value){
                var newArr = [];
                                
                arr[arr.length] = value;
                newArr = arr;
                return newArr;
            },
            //Update Element in Json Array
            update: function(arr, uid, newvalue){
                for (var key in arr) {                    
                    if (arr.hasOwnProperty(key)) {
                        if(arr[key].uid === uid){
                            //console.log(key + " -> " + arr[key]);
                            arr[key] = newvalue;
                        }
                    }
                }
                return arr;
            },
            //remove Element in Json Array
            remove: function(arr, value){
                var newArr = [];
                
                for (var key in arr) {                    
                    if (arr.hasOwnProperty(key)) {
                        if(arr[key].uid !== value){
                            //console.log(key + " -> " + arr[key]);
                            //arr[key] = newvalue;
                            newArr.push(arr[key]);
                        }
                    }
                }
                return newArr;
            },                
            //Remove Element from Json Array
            remove2: function(arr, value){
                newArr = [];
                for(var i = 0, l = arr.length;i < l; i++){
            	   p = arr[i];
                    for (var key in p) {
       	                if (p.hasOwnProperty(key)) {
                            if(p[key] !== value){
                                newArr.push(arr[i]);
                            }
           	            }
                    }
                }
                return newArr;
            },
            getByUid: function(arr, uid){
                var data = {};
                for (var key in arr) {                    
                    if (arr.hasOwnProperty(key)) {
                        if(arr[key].uid === uid){
                            data = arr[key];
                        }
                    }
                }
                return data;                
            }
        }; // end return
    }
})();

(function() {
    'use strict';
    mobileApp.factory('apiService', ['$http', '$q', apiService]);
    var response = {};
        
    function apiService($http, $q) {
        var start = new Date().getTime();
        
        return {
            exec: function(method, endpoint, params) {
                    return $http({method: method, url: endpoint, data: params}).success(function (response){
                        //console.log(response);
                                                                        
                        //console.log('time taken for request: ' + (new Date().getTime() - start) + 'ms');
                        if(response.error) {
                            return false;
                        }
                        return response;
                    });
            }
        }
    }
})();

(function() {
    'use strict';
	mobileApp.factory('_', function() {
		return window._;
	});
})();

(function() {
    'use strict';
	mobileApp.factory('tbl', function() {
	   //var cities = TAFFY();
		return window.TAFFY();
	});
})();


mobileApp.factory('Geolocation', function($rootScope, $http) {
	return {
		getCurrentPosition: function(onSuccess, onError, options) {
            //ionic.Platform.ready(function(){
                var options = { timeout: 80000, enableHighAccuracy: true }; 
          		navigator.geolocation.getCurrentPosition(
          			function () {
            			var that = this,
              			args = arguments;

            			if (onSuccess) {
              				$rootScope.$apply(function () {
                				onSuccess.apply(that, args);
              				});
            			}
    				},
    				//error
    				function () {
    					var that = this, args = arguments;
            			if (onError) {
            				$rootScope.$apply(function () {
                				onError.apply(that, args);
            				});
        				}
      				},
        			options
        		);
           // });
		},
		watchPosition: function(onSuccess, onError, options) {
			var options = { timeout: 30000, enableHighAccuracy: true };	
            //ionic.Platform.ready(function(){
    			navigator.geolocation.watchPosition(
    	        	function(){
            			var that = this,
              			args = arguments;

            			if (onSuccess) {
              				$rootScope.$apply(function () {
                				onSuccess.apply(that, args);
              				});       				
            			}        	
    	        	},
    	        	// Error
    	        	function(error){
    					alert('code: '    + error.code    + '\n' +
                  			  'message: ' + error.message + '\n');
    	        	},
    	        	// Settings
    	        	options
    	        );
            //});
	    } 		
	};
});
  