//'use strict';
var mobileApp = angular.module('mobileApp', ['ionic', 'ui.bootstrap', 'ngResource', 'ngRoute', 'ionic.contrib.frostedGlass']);

(function() {

    mobileApp.config(['$routeProvider', '$locationProvider', '$httpProvider', '$stateProvider', '$urlRouterProvider',
        function config($routeProvider, $locationProvider, $httpProvider, $stateProvider, $urlRouterProvider) {
            $locationProvider.html5Mode(false);
            $locationProvider.hashPrefix('!');
            var checkLoggedin = function($q, $timeout, $http, $location, $rootScope, localStorage) {
                // Initialize a new promise
                var deferred = $q.defer();
                var tokenLocal = localStorage.get('token');
                if (tokenLocal == '') {
                    $location.path('/login');
                } else {
                    var url = $rootScope.loginUrl + '/check/token/' + tokenLocal;
                    $rootScope.tokenLocal = tokenLocal;
                    $timeout(deferred.resolve, 100);
                    return deferred.promise;
                }
            };

            $httpProvider.responseInterceptors.push(function($q, $location,$rootScope) {
                return function(promise) {
                    return promise.then(
                        // Success: just return the response
                        function(response) {
                            return response;
                        },
                        // Error: check the error status to get only the 401
                        function(response) {
                            if (response.status === 401) $location.url('/login');
                                //$location.url('/');
                                 $rootScope.hide();
                            return $q.reject(response);
                        }
                    );
                }
            });

            var mainPath = 'scripts/modules/';
            $stateProvider
                .state('/', {
                    url: '/',
                    templateUrl: 'dashboard.html?v=queue',
                    controller: 'DashboardCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('survey', {
                    url: '/survey/:id',
                    templateUrl: 'survey.html?v=queue',
                    controller: 'SurveyCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('holdprioritas', {
                    url: '/holdprioritas/:id',
                    templateUrl: 'holdprioritas.html',
                    controller: 'HoldprioritasCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('history', {
                    url: '/history',
                    templateUrl: 'history.html?v=queue',
                    controller: 'HistoryCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('historydetail', {
                    url: '/historydetail/:id',
                    templateUrl: mainPath + 'dashboard/history-detail.html',
                    controller: 'HistoryCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('comment', {
                    url: '/comment/:id',
                    templateUrl: mainPath + 'dashboard/comment-survey.html',
                    controller: 'CommentCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('commentactive', {
                    url: '/comment/:id/:ac',
                    templateUrl: mainPath + 'dashboard/comment-survey.html',
                    controller: 'CommentCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('route', {
                    url: '/route/:id',
                    templateUrl: mainPath + 'dashboard/route.html',
                    controller: 'RouteCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('customer', {
                    url: '/customer/:id',
                    templateUrl: 'customer.html?v=queue',
                    controller: 'CustomerCtrl',
                    resolve: {
                        loggedin: checkLoggedin
                    }
                })
                .state('login', {
                    url: '/login',
                    templateUrl: 'login.html',
                    controller: 'LoginCtrl'
                })
                .state('register', {
                    url: '/register',
                    templateUrl: 'register.html',
                    controller: 'RegisterCtrl'
                })

            $urlRouterProvider.otherwise('/');
        }
    ]); // end of config()
    mobileApp.run(['$rootScope', '$http', 'localStorage', '$location', '$window', 'loginUrl','registerUrl', '$ionicLoading', 'pgPushNotificationsFactory','$ionicPopup','networkStates','WebSqlDbService',
        function($rootScope, $http, localStorage, $location, $window, loginUrl,registerUrl, $ionicLoading, pgPushNotificationsFactory,$ionicPopup,networkStates,WebSqlDbService) {
            /* push notif */
            $http.defaults.useXDomain = true;
            delete $http.defaults.headers.common['X-Requested-With'];

            document.addEventListener("offline", function(){
                    window.plugins.toast.show(
                            'Connection failure', 'long', 
                            'center', function(a){
                                console.log('toast success: ' + a)
                            }, function(b){})
                    $rootScope.$apply(function() {
                        $rootScope.networkState = false;
                    });
                }
            , false);
            document.addEventListener("online", function(){
                    console.log('onOnline');
                    $rootScope.$apply(function() {
                        $rootScope.networkState = true;
                    });
                }
            , false);
            $rootScope.$on('networkState', function(e) {
                 $rootScope.networkState = e;
            });
            $rootScope.task = 0;
            $rootScope.cmnts =0;
            ionic.Platform.ready(function(){

                $http({
                    method  : 'GET',
                    // url     : 'http://survey.code.redwhite.co.id/apk/version.php',
                    url     : 'http://118.97.199.21/apk/version.php',
                    headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            }
                 }).success(function(data){
                    // With the data succesfully returned, call our callback
                    console.log(JSON.stringify(data));
                    var currVersion = data.version_name;

                    window.plugins.version.getVersionCode(
                        function(version_code) {
                            console.log("Installed version code: " + version_code);
                            $rootScope.version_code = version_code;
                            localStorage.set('version_code', version_code);
                        }
                    );

                    window.plugins.version.getVersionName(
                        function(version_name) {
                          console.log("Installed version: " + version_name);
                          $rootScope.version_name = version_name;
                         if(version_name != currVersion){
                            console.log("Upgrade app!");

                            $rootScope.logout
                            var fileSystem;
                          console.log("downloading file.")

                          window.requestFileSystem(LocalFileSystem.TEMPORARY, 0,
                              function(fs) {
                                fileSystem = fs;
                               
                                var uri = encodeURI("http://118.97.199.21/apk/index.php");
                                //var uri = encodeURI("http://survey.code.redwhite.co.id/apk/index.php");
                                fs.root.getFile(
                                    'AksimayaSurvey-release.apk',
                                    {create: true, exclusive: false},
                                    function(fileEntry) {
                                        var downloadPath = fileEntry.toURL().replace('AksimayaSurvey-release.apk', '');
                                        var ft = new FileTransfer();
                                        fileEntry.remove();
                                        navigator.notification.progressStart("Application Update", "Initiating download...");
                                        ft.onprogress = function(progressEvent) {
                                          if (progressEvent.lengthComputable) {
                                            var perc = Math.floor(progressEvent.loaded / progressEvent.total * 100);
                                            //statusDom.innerHTML = perc + "% loaded...";
                                            navigator.notification.progressValue(perc);
                                          }
                                        };
                                        ft.download(uri, downloadPath+'Aksimaya-release.apk',
                                            function(theFile) {
                                              navigator.notification.progressStop();
                                              console.log("download complete: " + theFile.toURL());
                                              window.plugins.webintent.startActivity({
                                                    action: window.plugins.webintent.ACTION_VIEW,
                                                    url: 'file://' + theFile.toURL(),
                                                    type: 'application/vnd.android.package-archive'
                                                  },
                                                  function() {},
                                                  function() {
                                                    alert('Failed to open URL via Android Intent.');
                                                    console.log("Failed to open URL via Android Intent. URL: " + theFile.fullPath)
                                                  }
                                              );
                                            },
                                            function(error) {
                                              alert("download error: " + JSON.stringify(e));
                                              console.log("download error: " + JSON.stringify(e));
                                            });
                                    },
                                    function(evt) {
                                        console.log(evt.target.error.code);
                                    }
                                );
                              }, function(e) {
                                alert('failed to get fs: ' + JSON.stringify(e));
                                console.log("failed to get fs: " + JSON.stringify(e));
                              });

                            /*
                            navigator.notification.confirm(
                                'A new version is out! Get it now!',  // message
                                function(button){
                                    
                                    if(button == 1){
                              
                                    }
                                },            // callback to invoke with index of button pressed
                                'Update available',                 // title
                                'Update now!, Maybe later'     // buttonLabels
                            );
                            */
                          }
                        },

                        function(errorMessage) {
                          console.log("Error while downloading update: " + errorMessage);
                        }
                    );

                }).error(function(){
                    console.log("FAILED : GET VERSION FROM SERVER");
                });

                
                //console.log(kk)

                plugins.DeviceInfo.imeiNumber(function(imei){
                        console.log("IMEI -->",imei);
                        //$rootScope.uidDb = $rootScope.imei = imei;
                        $rootScope.uidDb = 'aksimayaDB'
                        $rootScope.imei = imei;
                        $rootScope.$broadcast('imeiavailable', true);
                        $rootScope.$apply();

                    });
                 new pgPushNotificationsFactory(
                    '988550772341', // GCM Sender ID
                    function registeredCallback(deviceToken, platform) {
                        console.log('deviceToken : ' + deviceToken);
                        $rootScope.regid = deviceToken;
                    }
                );
                 $rootScope.$on('phonegapPush.notification', function(event, notification) {

                    if (notification.data.types == 'Assignment') {
                        /*$ionicPopup.alert({
                          title: 'Assignment Notification',
                          content: notification.data.message
                        }).then(function(res) {
                          console.log(notification.data.message);
                        });*/
                        window.plugins.toast.show(
                            notification.data.message, 'long', 
                            'center', function(a){
                                console.log('toast success: ' + a)
                            }, function(b){})
                        $rootScope.$apply(function() {
                            $rootScope.task = $rootScope.task + 1;
                        });
                    }
                    if (notification.data.types == 'Comments') {
                        /*$ionicPopup.alert({
                          title: 'Comments Notification',
                          content: notification.data.message
                        }).then(function(res) {
                          console.log(notification.data.message);
                        });*/
                        window.plugins.toast.show(
                            notification.data.message, 'long', 
                            'center', function(a){
                                console.log('toast success: ' + a)
                            }, function(b){})
                        $rootScope.$apply(function() {
                            $rootScope.cmnts = $rootScope.cmnts + 1;
                            $rootScope.uidMMcmnts = notification.data.uid;
                            //$scope.$broadcast('refreshTask');  
                        });
                    }
                });
                /*end push notif*/
            });

            $rootScope.checkcomment = function(c){
                    $rootScope.cmnts = 0;
                    $location.path('comment/'+c+'/1');
            }

            var userUid = localStorage.get('userUid');
            $rootScope.setTab = function(t) {

                $rootScope.tabbed = t;
            }
            $rootScope.userUid = userUid;

            

            $rootScope.loginUrl = loginUrl;
            $rootScope.registerUrl = registerUrl;
            $rootScope.token = '';
            $rootScope.message = '';
            $rootScope.controller = 'page-login';
            $rootScope.logout = function() {
                $rootScope.message = 'Logged out.';
                $http.defaults.useXDomain = true;
                delete $http.defaults.headers.common['X-Requested-With'];

                var tokenLocal = localStorage.get('token');
                $location.url('/login');
                localStorage.set('token', '');
                //window.localStorage.clear();
                var url = $rootScope.loginUrl + '/logout/token/' + tokenLocal;
                $http.get(url);               
                $rootScope.token = '';
            };
            $rootScope.go = function(path) {
                if (path == 1) {
                    window.history.back();
                } else {
                    $location.path(path);
                }

            };
             $rootScope.$on('$stateChangeStart', 
                function(event, toState, toParams, fromState, fromParams){ 
                    $rootScope.show();
                });
            $rootScope.$on('$stateChangeSuccess', 
                function(event, toState, toParams, fromState, fromParams){
                        $rootScope.hide();
                });
            $rootScope.$on('$stateChangeError', 
                function(event, toState, toParams, fromState, fromParams, error){ 
                         $rootScope.hide();
                });
            $rootScope.$on('$stateNotFound', 
                function(event, unfoundState, fromState, fromParams){ 
                   $rootScope.hide();
                });
            $rootScope.show = function() {
                $rootScope.loading = $ionicLoading.show({
                    content: 'Loading',
                    animation: 'fade-in',
                    showBackdrop: true,
                    maxWidth: 200,
                    showDelay: 10
                });
            };
            $rootScope.hide = function() {
                $rootScope.loading.hide();
            };
        }
    ]);
    mobileApp.constant('apiUrl', 'http://118.97.199.21/mobile/api'); 
    mobileApp.constant('loginUrl', 'http://118.97.199.21/mobile/login');
    mobileApp.constant('registerUrl', 'http://118.97.199.21/mobile/register');
    mobileApp.constant('attacUrl', 'http://118.97.199.21/pictures/')
    //mobileApp.constant('apiUrl', 'http://survey.code.redwhite.co.id/mobile/api');
    //mobileApp.constant('loginUrl', 'http://survey.code.redwhite.co.id/mobile/login');
    //mobileApp.constant('registerUrl', 'http://survey.code.redwhite.co.id/mobile/register');
    //mobileApp.constant('attacUrl', 'http://survey.code.redwhite.co.id/pictures/')
    mobileApp.filter('assignmentnoformat', function() {
        return function(text) {
            var assNo = "" + text;
            while (assNo.length < 7) assNo = "0" + assNo;
            return assNo;
        };
    });
    mobileApp.filter('timestamp', function() {
        return function(dateString, format) {
            var t = new Date(dateString * 1000);
            return moment(t).calendar();
        };
    });
    mobileApp.factory('cordovaReady', function() {
              return function (fn) {
                var queue = [];
                var impl = function () {
                  queue.push(Array.prototype.slice.call(arguments));
                };
                document.addEventListener('deviceready', function () {
                  queue.forEach(function (args) {
                    fn.apply(this, args);
                  });
                  impl = fn;
                }, false);

                return function () {
                  return impl.apply(this, arguments);
                };
              };
            });
    mobileApp.factory('networkStates',['$rootScope','cordovaReady','$http', function ($rootScope, cordovaReady,$http) {
      return {
        getNetworkState:function () {
                var networkState = navigator.connection.type;
                    var states = {};
                    states[Connection.UNKNOWN]  = 'Unknown connection';
                    states[Connection.ETHERNET] = 'Ethernet connection';
                    states[Connection.WIFI]     = 'WiFi connection';
                    states[Connection.CELL_2G]  = 'Cell 2G connection';
                    states[Connection.CELL_3G]  = 'Cell 3G connection';
                    states[Connection.CELL_4G]  = 'Cell 4G connection';
                    states[Connection.NONE]     = 'No network connection';
                   
                  
                     if (states[networkState] === 'No network connection') {
                        $rootScope.$broadcast("networkState", false);
                       // callback(false);
                        return false;
                     }else{
                        if(states[networkState] === 'WiFi connection' ){
                            $rootScope.$broadcast("networkState", true);
                            //callback(true);
                            return true;                            
                        }else{
                            $rootScope.$broadcast("networkState", true);
                           // callback(true);
                            return true;
                        }
                    }
            },
        };
    }]);
    return mobileApp;
})();