/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


function registerPushAksimayaAndroid() {

	var pushNotification = window.plugins.pushNotification;

	//push notifications handler
	document.addEventListener('push-notification', function(event) {
	            var message = event.notification.message;
	            var userData = event.notification.userdata;
	            //console.warn('user data: ' + JSON.stringify(event.notification));
	            //dump custom data to the console if it exists
	            if(typeof(userData) != "undefined") {
					console.warn('user data: ' + JSON.stringify(userData));
				}

				//and show alert

				navigator.notification.alert(message);

				//stopping geopushes
				//pushNotification.stopGeoPushes();
			  });
	pushNotification.register(successHandler, errorHandler, {"senderID":"946855876246","ecb":"onNotificationGCM"});

 }
function successHandler (result) {
	console.warn(JSON.stringify(['register ID : ', result]));

}

function errorHandler (error) {
	console.warn(JSON.stringify(['failed to register ', error]));
}

function initPushAksimaya() {
	var pushNotification = window.plugins.pushNotification;
	//set multi notificaiton mode
	//pushNotification.setMultiNotificationMode();
	//pushNotification.setEnableLED(true);

	//set single notification mode
	//pushNotification.setSingleNotificationMode();

	//disable sound and vibration
	//pushNotification.setSoundType(1);
	//pushNotification.setVibrateType(1);
	pushNotification.setLightScreenOnNotification(true);
	if (device.platform == 'android' || device.platform == 'Android')
	{
		registerPushAksimayaAndroid();
		pushNotification.onDeviceReady();
	}
}
function onNotificationGCM(e) {
	//console.log('regidnya: '+  e.regid);
    $("#app-status-ul").append('<li>EVENT -> RECEIVED:' + e.event + '</li>');
    
    switch( e.event )
    {
        case 'registered':
		if ( e.regid.length > 0 )
		{
			console.log("regID = " + e.regid);
		}
        break;
        
        case 'message':
        	console.warn('notificaiton: ' + JSON.stringify(e));
        	// if this flag is set, this notification happened while we were in the foreground.
        	// you might want to play a sound to get the user's attention, throw up a dialog, etc.
        	if (e.foreground)
        	{
				// if the notification contains a soundname, play it.
				//var my_media = new Media("/android_asset/www/"+e.soundname);
				//my_media.play();
			}
			else
			{	// otherwise we were launched because the user touched a notification in the notification tray.
				if (e.coldstart)
					console.log("coldstart = " +e.coldstart);
				else
					console.log("BACKGROUND = " +e.coldstart);
			}
			console.log("messageMSG = " +e.payload.message);	
			console.log("messageMSGCNT = " +e.payload.msgcnt);	
        break;
    }
}

var push = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    // deviceready Event Handler
    //
    // The scope of 'this' is the event. In order to call the 'receivedEvent'
    // function, we must explicity call 'app.receivedEvent(...);'
    onDeviceReady: function() {
        initPushAksimaya();
        push.receivedEvent('deviceready');
    },
    // Update DOM on a Received Event
    receivedEvent: function(id) {
        /*var parentElement = document.getElementById(id);
        var listeningElement = parentElement.querySelector('.listening');
        var receivedElement = parentElement.querySelector('.received');

        listeningElement.setAttribute('style', 'display:none;');
        receivedElement.setAttribute('style', 'display:block;');*/

        console.log('Received Event: ' + id);
    }
};