/*global SqliteStorage_msgs: false */
'use strict';

/**
 * error messages
 */
angular.module('SqliteStorage', []).constant('SqliteStorage_msgs', {
    'errors.SqliteStorage.notSupported': 'window.openDatabase is not supported on this device'
});

/**
 * Angular Sqlite Storage
 */
angular.module('SqliteStorage').factory('SqliteStorage', [
    '$q',
    '$rootScope',
    '$window',
    'SqliteStorage_msgs',
    function ($q, $rootScope, $window, SqliteStorage_msgs,$document) {
        var storage = {};

        var extendSQLTransaction = function (tx, queryFn) {
            var exTx = {};
            angular.extend(exTx, tx);

            exTx.executeSql = function (queryString) {
                var deferred = $q.defer();
                //
                tx.executeSql(queryString, [], function (tx, results) {
                    //console.log(results);
                    //$rootScope.$apply( deferred.resolve({tx: tx, resultSet: results}) );
                    //ferred.resolve({tx: tx, resultSet: results})
                    $rootScope.$apply(function() {
                                        callback.apply(socket, args);
                                });
                }, function (err) {
                    $rootScope.$apply( deferred.reject(err) );
                });

                return deferred.promise;
            };

            return queryFn(exTx);
        };

        var extendDatabase = function (db) {
            var exDb = {};
            angular.extend(exDb, db);

            exDb.transaction = function (fn) {
                var deferred = $q.defer();
                //
                db.transaction(function (tx) {
                    extendSQLTransaction(tx, fn);
                }, function (err) {
                    // error callback
                    $rootScope.$apply( deferred.reject(err) );
                }, function () {
                    // success callback
                     deferred.resolve();
                    //$rootScope.$apply( deferred.resolve() );
                });

                return deferred.promise;
            };

            exDb.changeVersion = db.changeVersion;

            return exDb;
        };

        storage.openDatabase = function (database_name) {
            var deferred = $q.defer();

            if ($window && $window.sqlitePlugin) {
                //
                var db = $window.sqlitePlugin.openDatabase({name:database_name});
                //ferred.resolve(extendDatabase(db));
                return db;
            } else {
                // storage api is not defined or permitted.
                $rootScope.$broadcast('error', SqliteStorage_msgs['errors.SqliteStorage.notSupported']);
               /* $rootScope.$apply( function () {
                    deferred.reject(SqliteStorage_msgs['errors.SqliteStorage.notSupported']);
                });*/
            }

            return deferred.promise;
        };

        return storage;
    }]);