(function() {
    'use strict';
    
    mobileApp.controller('HoldprioritasCtrl', ['$scope', '$rootScope', '$http', '$location', '$stateParams', 'Surveys', 'Geolocation','WebSqlDbService','attacUrl','$ionicPopup','$ionicActionSheet', HoldprioritasCtrl]);

    function HoldprioritasCtrl($scope, $rootScope, $http, $location, $stateParams, Surveys, Geolocation,WebSqlDbService,attacUrl,$ionicPopup,$ionicActionSheet) {
        console.log('hold prioritas loaded ... ');
        
        if (!$rootScope.dtHold) $location.url('/survey/'+$stateParams.id);

        var dtHold = $rootScope.dtHold;
        $scope.tabbed = 'reschedule';
        $scope.stateParams = $stateParams;
        $scope.reSchedule = {};
        console.log('dtHold', dtHold);

        $scope.holdSurveyPrioritas = function(){
            var d = dtHold.d;
            
            if ($rootScope.networkState == false) {
                window.plugins.toast.show(
                'Connection not found', 'long', 
                'center', function(a){
                    console.log('toast success: ' + a)
                }, function(b){})
            } 
            else {

                if($scope.reSchedule.hour && $scope.reSchedule.minute) {
                    var conf = confirm('Yakin akan menunda survey ini ?');
                    if(conf){
                        $rootScope.show();
                        var location_submit = {lat:dtHold.position.coords.latitude,lon:dtHold.position.coords.longitude}; 
                        var res = {
                            'customer_uid'   : dtHold.survey.customer_uid,
                            'employee_uid'   : dtHold.survey.employee_uid,
                            'supervisor_uid' : dtHold.survey.supervisor_uid,
                            'form_type'      : dtHold.survey.form_type,
                            'assignment_uid' : dtHold.survey.assignment_uid,
                            'uid'            : $stateParams.id,
                            'result'         : d,
                            'location_submit': JSON.stringify(location_submit),
                            'location_draft' : dtHold.location_draft ? JSON.stringify(dtHold.location_draft) : "",
                            'images'         : {},

                            'prioritas'      : 1,
                            'assignment_qty' : dtHold.survey.assignment_qty,
                            'zipcode'        : dtHold.survey.customer[0].zipcode,
                            'branch_uid'     : dtHold.survey.branch_uid,
                            'reSchedule'     : $scope.reSchedule,
                            'schedule_uid'   : dtHold.survey.schedule_uid
                        };
            
                        res['images'] = dtHold.dataPicPost;

                        console.log(res);

                        objModel.holdSurvey(res, $rootScope.tokenLocal, function(r) {
                            if (r.status === 'success') {
                                $scope.tabbed  = 'msg';
                                $scope.msgDone = 'Data Has been Hold';
                                objModel.clearCache();
                            }
                            else {
                                alert('Failed send data, please try again.');
                            }
                            $rootScope.hide();
                        });
                    }
                }
                else {
                    alert('Jam dkirim ulang kembali survey ini harus diisi');
                }
            }
        }

        var objModel = Surveys;

        getScheduleToday();

        function getScheduleToday(){
            $rootScope.show();
            var jn    = [];
                jn[0] = 'customer';
            objModel.getScheduleToday({
                "join": jn,
                "filter[employee_uid]": dtHold.survey.employee_uid,
                "token": $rootScope.tokenLocal
            }, function(d) {
                console.log('schedule', d);
                $scope.scheduleToday = d;
                $rootScope.hide();
            });
        }

        $scope.range = function(min, max, step) {
            step = step || 1;
            var input = [];
            for (var i = min; i <= max; i += step) {
                input.push(i);
            }
            return input;
        };
        
        $scope.setTab = function(tab){
            $scope.tabbed = tab;
        }
        
    };
})();