(function(){
    

    /**********************************************************************
     * Register controller
     **********************************************************************/
    mobileApp.controller('RegisterCtrl', ['$scope', '$rootScope', '$http', '$location','Geolocation','localStorage','WebSqlDbService',RegisterCtrl]);
    function RegisterCtrl($scope, $rootScope, $http, $location,Geolocation,localStorage,WebSqlDbService) {
        
        $scope.User = {'email':'','password':'','email':''};
    	
        getGeo();
        $scope.position = {'coords':''};
        
        $scope.register = function(){
        if($scope.User.password && $scope.User.username) {   

            var imei = $rootScope.imei;
            console.log("IMEI DEVICE : "+imei);                 
            $scope.User.imei = imei;

            var url = $rootScope.registerUrl + '/';
            $scope.loginMessage = "Registering...";
            
            var regId =$rootScope.regid;

            $scope.User.lat         = $scope.position.coords.latitude;
            $scope.User.long        = $scope.position.coords.longitude;
            $scope.User.regid       = regId;
            $rootScope.show();
            
            $http({
                url: url,
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                data:$scope.User
            }).success(function (data, status) {
            	
                if(data.status === true){
                    
                    var reset = false;
                    WebSqlDbService.createTables(reset);
                    
                    // UPDATE DATE USER LOGIN FROM SERVER 
                    // -------------------------------
                    var userInfo =  {
                        uid         : data.uid,
                        username    : data.username,
                        password    : md5($scope.User.password),
                        token       : data.token,
                        imei        : data.imeiDb
                    };
                    WebSqlDbService.execUpdate("user",userInfo);
                    // =================================
                    
                    $rootScope.hide();
                    $scope.loginMessage = "Success... Registering...";
                    $rootScope.token = data.token;
                    $rootScope.uidUser = data.uid;
                    $rootScope.username = data.username; 
                    localStorage.set('token', data.token);
                    localStorage.set('uidUser', data.uid);
                    localStorage.set('username', data.username);
                    
                    $scope.loginMessage = "";
                    $location.url('/');
                }   
                else{
                	$scope.User.password = '';
                    $scope.loginMessage = "";
                    $scope.loginErrorMessage = true;
                    $rootScope.hide();
                    $location.url('/register');
                }
            }).error(function (data, status) {
                $scope.User.password = '';
                $scope.loginMessage = "";
                $scope.loginErrorMessage = true;
                $rootScope.hide();
                $location.url('/register');
            });
        };
        };
        
        function getGeo(){
            Geolocation.getCurrentPosition(function(position) {
                $scope.position=position;
                //console.log('geo : ',JSON.stringify(position));
                //$rootScope.$apply();              
            });
        }
    };
})();