<!---
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

# org.apache.cordova.file

Этот плагин реализует API файла, позволяя доступ на чтение и запись в файлы, находящиеся на устройстве.

Этот плагин основан на нескольких спецификации, в том числе: HTML5 API файла <http://www.w3.org/TR/FileAPI/>

(Ныне несуществующей) каталоги и систему расширений Последнее: <http://www.w3.org/TR/2012/WD-file-system-api-20120417/> , хотя большая часть кода, плагин был написан, когда ранее спец был текущим: <http://www.w3.org/TR/2011/WD-file-system-api-20110419/>

Он также реализует уничтожал spec: <http://dev.w3.org/2009/dap/file-system/file-writer.html>

Для использования, пожалуйста, обратитесь к HTML5 скалы отличные [файловой системы статьи.][1]

 [1]: http://www.html5rocks.com/en/tutorials/file/filesystem/

Обзор других вариантов хранения найти Cordova [хранения руководства][2].

 [2]: http://cordova.apache.org/docs/en/edge/cordova_storage_storage.md.html

## Установка

    cordova plugin add org.apache.cordova.file
    

## Поддерживаемые платформы

*   Amazon Fire OS
*   Android
*   BlackBerry 10
*   Firefox OS
*   iOS
*   Windows Phone 7 и 8 *
*   Windows 8 *

* *Эти платформы не поддерживают `FileReader.readAsArrayBuffer` , ни `FileWriter.write(blob)` .*

## Где хранить файлы

По состоянию на v1.2.0 приведены URL-адреса для важных файлов в системные каталоги. Каждый URL-адрес в виде *file:///path/to/spot/*и может быть преобразован в `DirectoryEntry` с помощью`window.resolveLocalFileSystemURL()`.

*   `cordova.file.applicationDirectory`-Каталог только для чтения, где установлено приложение. (*iOS*, *Android*, *BlackBerry 10*)

*   `cordova.file.applicationStorageDirectory`-Корневой каталог приложения в песочнице; на iOS это место только для чтения (но определенных подкаталогов [как `/Documents` ], чтения записи). Все данные, содержащиеся в частных в приложение. ( *iOS*, *Android*, *BlackBerry 10*)

*   `cordova.file.dataDirectory`-Хранения стойкие и частных данных в приложения в песочнице с использованием внутренней памяти (на Android, если необходимо использовать внешнюю память, использовать `.externalDataDirectory` ). На iOS, этот каталог не синхронизируется с iCloud (использование `.syncedDataDirectory` ). (*iOS*, *Android*, *BlackBerry 10*)

*   `cordova.file.cacheDirectory`-Каталог для кэшированных данных файлов или все файлы, которые ваше приложение может повторно создать легко. ОС может удалить эти файлы, когда устройства хватает на хранение, тем не менее, приложения не должны опираться на OS, чтобы удалить файлы здесь. (*iOS*, *Android*, *BlackBerry 10*)

*   `cordova.file.externalApplicationStorageDirectory`-Пространство приложения на внешнем хранилище. (*Android*)

*   `cordova.file.externalDataDirectory`-Куда положить файлы данных конкретного приложения на внешнем хранилище. (*Android*)

*   `cordova.file.externalCacheDirectory`-Применение кэш на внешние накопители. (*Android*)

*   `cordova.file.externalRootDirectory`-Корень внешние накопители (SD карта). (*Android*, *BlackBerry 10*)

*   `cordova.file.tempDirectory`-Временный каталог, что ОС можно снять на будет. Не следует полагаться на OS, чтобы очистить этот каталог; Ваше приложение всегда следует удалять файлы в соответствующих случаях. (*iOS*)

*   `cordova.file.syncedDataDirectory`-Содержит файлы приложения, которые должны быть синхронизированы (например, к iCloud). (*iOS*)

*   `cordova.file.documentsDirectory`-Файлы для приложения, но это являются значимыми для других приложений (например, файлы Office). (*iOS*)

*   `cordova.file.sharedDirectory`-Файлы глобально доступной для всех приложений (*BlackBerry 10*)

## Макеты файловой системы

Хотя технически деталь реализации, она может быть очень полезно знать как `cordova.file.*` карта свойства физические пути на реальном устройстве.

### iOS расположения файловой системы

| Путь к устройству                              | `Cordova.File.*`            | `iosExtraFileSystems` | r/w? | стойкие? | Очищает ОС | Синхронизация | частные |
|:---------------------------------------------- |:--------------------------- |:--------------------- |:----:|:--------:|:----------:|:-------------:|:-------:|
| `/ var/мобильного/применения/< UUID > /` | applicationStorageDirectory | -                     |  r   |   Н/Д    |    Н/Д     |      Н/Д      |   Да    |
|    `appname.app/`                              | applicationDirectory        | расслоение            |  r   |   Н/Д    |    Н/Д     |      Н/Д      |   Да    |
|       `www/`                                   | -                           | -                     |  r   |   Н/Д    |    Н/Д     |      Н/Д      |   Да    |
|    `Documents/`                                | documentsDirectory          | документы             | r/w  |    Да    |    Нет     |      Да       |   Да    |
|       `NoCloud/`                               | -                           | документы nosync      | r/w  |    Да    |    Нет     |      Нет      |   Да    |
|    `Library`                                   | -                           | Библиотека            | r/w  |    Да    |    Нет     |      Да?      |   Да    |
|       `NoCloud/`                               | dataDirectory               | Библиотека nosync     | r/w  |    Да    |    Нет     |      Нет      |   Да    |
|       `Cloud/`                                 | syncedDataDirectory         | -                     | r/w  |    Да    |    Нет     |      Да       |   Да    |
|       `Caches/`                                | cacheDirectory              | кэш                   | r/w  |   Да *   | Да * * *| |      Нет      |   Да    |
|    `tmp/`                                      | tempDirectory               | -                     | r/w  |  Не * *  | Да * * *| |      Нет      |   Да    |

* Файлы сохраняются приложения перезагрузки и обновления, но этот каталог может быть очищен, когда ОС желаний. Ваше приложение должно иметь возможность воссоздать любое содержание, которое может быть удалено.

* * Файлы могут сохраняться перезагрузками app, но не полагайтесь на это поведение. Для продолжения обновления файлов не гарантируется. Приложение должно удалить файлы из этого каталога, когда это применимо, как операционная система не гарантирует когда (или даже если) эти файлы будут удалены.

* * *| ОС может очистить содержимое этого каталога, когда он считает это необходимым, но не полагайтесь на это. Необходимо снять этот каталог в зависимости от вашего приложения.

### Расположения Android файловой системы

| Путь к устройству                 | `Cordova.File.*`                    | `AndroidExtraFileSystems` | r/w? | стойкие? | Очищает ОС | частные |
|:--------------------------------- |:----------------------------------- |:------------------------- |:----:|:--------:|:----------:|:-------:|
| `File:///android_asset/`          | applicationDirectory                |                           |  r   |   Н/Д    |    Н/Д     |   Да    |
| `/ Data/data/< app-id > /`  | applicationStorageDirectory         | -                         | r/w  |   Н/Д    |    Н/Д     |   Да    |
|    `cache`                        | cacheDirectory                      | кэш                       | r/w  |    Да    |    Да *    |   Да    |
|    `files`                        | dataDirectory                       | файлы                     | r/w  |    Да    |    Нет     |   Да    |
|       `Documents`                 |                                     | документы                 | r/w  |    Да    |    Нет     |   Да    |
| `< sdcard > /`              | externalRootDirectory               | SDCard                    | r/w  |    Да    |    Нет     |   Нет   |
|    `Android/data/<app-id>/` | externalApplicationStorageDirectory | -                         | r/w  |    Да    |    Нет     |   Нет   |
|       `cache`                     | externalCacheDirectry               | кэш внешние               | r/w  |    Да    |   Не * *   |   Нет   |
|       `files`                     | externalDataDirectory               | файлы внешние             | r/w  |    Да    |    Нет     |   Нет   |

* ОС может периодически удалять этот каталог, но не полагайтесь на это поведение. Очистите содержимое этого каталога в зависимости от вашего приложения. Если пользователь вручную очистить кэш, содержимое этого каталога будут удалены.

* * ОС не ясно этот каталог автоматически; Вы несете ответственность за управление содержимым самостоятельно. Если пользователь вручную очистить кэш, содержимое каталога будут удалены.

**Примечание**: Если нельзя монтировать внешние накопители, `cordova.file.external*` Свойства`null`.

### BlackBerry 10 расположения файловой системы

| Путь к устройству                                   | `Cordova.File.*`            | r/w? | стойкие? | Очищает ОС | частные |
|:--------------------------------------------------- |:--------------------------- |:----:|:--------:|:----------:|:-------:|
| `File:///Accounts/1000/AppData/ < app id > /` | applicationStorageDirectory |  r   |   Н/Д    |    Н/Д     |   Да    |
|    `app/native`                                     | applicationDirectory        |  r   |   Н/Д    |    Н/Д     |   Да    |
|    `data/webviews/webfs/temporary/local__0`         | cacheDirectory              | r/w  |   Нет    |     Да     |   Да    |
|    `data/webviews/webfs/persistent/local__0`        | dataDirectory               | r/w  |    Да    |    Нет     |   Да    |
| `File:///Accounts/1000/Removable/SDCard`            | externalRemovableDirectory  | r/w  |    Да    |    Нет     |   Нет   |
| `File:///Accounts/1000/Shared`                      | sharedDirectory             | r/w  |    Да    |    Нет     |   Нет   |

*Примечание*: при развертывании приложения для работы периметра, все пути относительны /accounts/1000-enterprise.

## Особенности Android

### Местоположение Android постоянного хранения

Есть несколько допустимых мест для хранения постоянных файлов на устройстве Android. Смотрите [эту страницу][3] для широкого обсуждения различных возможностей.

 [3]: http://developer.android.com/guide/topics/data/data-storage.html

Предыдущие версии плагина будет выбирать расположение временных и постоянных файлов при запуске, основанный на ли устройство утверждал, что SD-карта (или эквивалентные хранения раздел) был смонтирован. Если была смонтирована SD-карты, или если большой внутренней памяти раздел был доступен (такие как на устройствах Nexus,), то постоянные файлы будут храниться в корне этого пространства. Это означало, что все apps Cordova могли видеть все файлы, имеющиеся на карте.

Если SD-карты не был доступен, то предыдущих версий будет хранить данные в `/data/data/<packageId>` , которая изолирует приложения друг от друга, но все еще может причина данные распределяются между пользователями.

Это теперь можно выбрать, следует ли хранить файлы в месте хранения внутренних файлов, или с использованием предыдущей логики, с предпочтением в вашем приложении `config.xml` файл. Чтобы сделать это, добавить один из этих двух линий в `config.xml` :

    <preference name="AndroidPersistentFileLocation" value="Internal" />
    
    <preference name="AndroidPersistentFileLocation" value="Compatibility" />
    

Без этой линии, будет использовать файл плагина `Compatibility` по умолчанию. Если тег предпочтений присутствует и не является одним из этих значений, приложение не запустится.

Если ранее была отгружена приложения для пользователей, используя старые (до 1.0) версию этого плагина и имеет сохраненные файлы в файловой системе постоянных, то вы должны установить предпочтения `Compatibility` . Переключение местоположение для «Внутреннего» будет означать, что существующие пользователи, которые обновить их применение может быть не в состоянии получить доступ к их сохраненные ранее файлы, в зависимости от их устройства.

Если ваше приложение является новым или ранее никогда не хранит файлы в стойких файловой системы, то `Internal` как правило рекомендуется настройка.

## Особенности iOS

*   `cordova.file.applicationStorageDirectory`доступен только для чтения; попытка хранения файлов в корневом каталоге не удастся. Использовать один из других `cordova.file.*` свойства, определенные для iOS (только `applicationDirectory` и `applicationStorageDirectory` доступны только для чтения).
*   `FileReader.readAsText(blob, encoding)` 
    *   `encoding`Параметр не поддерживается, и UTF-8 кодирование действует всегда.

### iOS место постоянного хранения

Существует два допустимых местоположений для хранения постоянных файлов на устройства iOS: документы каталогов и библиотека. Предыдущие версии плагина только когда-либо постоянные файлы хранятся в папке документы. Это был побочный эффект делает все файлы приложения в iTunes, который часто был непреднамеренным, особенно для приложений, которые обрабатывают большое количество мелких файлов, вместо того, чтобы производить полный комплект документов для экспорта, который является цель каталога.

Это теперь можно выбрать, следует ли хранить файлы в документы или каталоге библиотеки, с предпочтением в вашем приложении `config.xml` файл. Чтобы сделать это, добавить один из этих двух линий в `config.xml` :

    <preference name="iosPersistentFileLocation" value="Library" />
    
    <preference name="iosPersistentFileLocation" value="Compatibility" />
    

Без этой линии, будет использовать файл плагина `Compatibility` по умолчанию. Если тег предпочтений присутствует и не является одним из этих значений, приложение не запустится.

Если ранее была отгружена приложения для пользователей, используя старые (до 1.0) версию этого плагина и имеет сохраненные файлы в файловой системе постоянных, то вы должны установить предпочтения `Compatibility` . Переключение расположения `Library` будет означать, что существующих пользователей обновить их применения будет не в состоянии получить доступ к их сохраненные ранее файлы.

Если ваше приложение является новым или ранее никогда не хранит файлы в стойких файловой системы, то `Library` как правило рекомендуется настройка.

## Особенности Firefox OS

API файловой системы изначально не поддерживается Firefox OS и реализуется как оболочка поверх indexedDB.

*   Не вынимая непустые каталоги
*   Не поддерживает метаданные для каталогов
*   Методы `copyTo` и `moveTo` не поддерживает каталоги

Поддерживаются следующие пути данных: * `applicationDirectory` -использует `xhr` чтобы получить локальные файлы, которые упакованы с приложением. * `dataDirectory` - Для постоянных данных конкретного приложения файлов. * `cacheDirectory` -Кэшированных файлов, которые должны выжить перезагрузки приложения (Apps не следует полагаться на OS, чтобы удалить файлы из здесь).

## Обновление примечания

В v1.0.0 этого плагина `FileEntry` и `DirectoryEntry` структур изменились, более соответствует опубликованной спецификации.

Предыдущий (pre-1.0.0) версии плагина хранятся устройства Абсолют файл расположение в `fullPath` свойства `Entry` объектов. Эти пути обычно будет выглядеть

    /var/mobile/Applications/<application UUID>/Documents/path/to/file  (iOS)
    /storage/emulated/0/path/to/file                                    (Android)
    

Эти пути также были возвращены `toURL()` метода `Entry` объектов.

С v1.0.0 `fullPath` атрибут является путь к файлу, *заданный относительно корня файловой системы HTML*. Таким образом, выше пути будет теперь оба быть представлено `FileEntry` объект с `fullPath` из

    /path/to/file
    

Если ваше приложение работает с устройства Абсолют путями, и ранее были получены эти пути через `fullPath` свойства `Entry` объектов, то вам следует обновить код для использования `entry.toURL()` вместо этого.

Для обратной совместимости, `resolveLocalFileSystemURL()` метод будет принимать путь Абсолют устройства и будет возвращать `Entry` объект, соответствующий его, до тех пор, как этот файл существует в рамках либо `TEMPORARY` или `PERSISTENT` файловых систем.

Это особенно была проблема с плагином передачи файлов, который ранее использовался устройства Абсолют пути (и все еще может принять их). Он был обновлен для корректной работы с файловой системы URL, так что замена `entry.fullPath` с `entry.toURL()` должен решить любые вопросы, получить этот плагин для работы с файлами на устройстве.

В v1.1.0 возвращаемое значение из `toURL()` был изменен (см. \[CB-6394\] (https://issues.apache.org/jira/browse/CB-6394)) для возвращения URL-адрес абсолютным «file://». где это возможно. Для обеспечения ' cdvfile:'-вы можете использовать URL-адрес `toInternalURL()` сейчас. Этот метод будет возвращать теперь файловой системы URL формы

    cdvfile://localhost/persistent/path/to/file
    

который может использоваться для уникальной идентификации файла.

## Список кодов ошибок и значения

Когда возникает ошибка, один из следующих кодов будет использоваться.

| Код | Постоянная                    |
| ---:|:----------------------------- |
|   1 | `NOT_FOUND_ERR`               |
|   2 | `SECURITY_ERR`                |
|   3 | `ABORT_ERR`                   |
|   4 | `NOT_READABLE_ERR`            |
|   5 | `ENCODING_ERR`                |
|   6 | `NO_MODIFICATION_ALLOWED_ERR` |
|   7 | `INVALID_STATE_ERR`           |
|   8 | `SYNTAX_ERR`                  |
|   9 | `INVALID_MODIFICATION_ERR`    |
|  10 | `QUOTA_EXCEEDED_ERR`          |
|  11 | `TYPE_MISMATCH_ERR`           |
|  12 | `PATH_EXISTS_ERR`             |

## Настройка плагина (опционально)

Набор доступных файловых систем может быть настроен на платформе. IOS и Android признают <preference> тег в `config.xml` имена которых файловые системы для установки. По умолчанию включены все корни файловой системы.

    <preference name="iosExtraFilesystems" value="library,library-nosync,documents,documents-nosync,cache,bundle,root" />
    <preference name="AndroidExtraFilesystems" value="files,files-external,documents,sdcard,cache,cache-external,root" />
    

### Android

*   `files`: Каталог для хранения внутреннего файла приложения
*   `files-external`: Каталог хранения внешнего файла приложения
*   `sdcard`: Глобальный внешний файл каталог хранения (это корень SD-карты, если таковая установлена). Вы должны иметь `android.permission.WRITE_EXTERNAL_STORAGE` разрешение использовать это.
*   `cache`: Каталог внутреннего кэша приложения
*   `cache-external`: Каталог приложения внешней кэш-памяти
*   `root`: Все устройство файловой системы

Android поддерживает также Специальный файловую систему под названием «документы», которая представляет подкаталог «/ документы /» в пределах файловой системы «файлы».

### iOS

*   `library`: Каталог библиотеки приложения
*   `documents`: Каталог документов приложения
*   `cache`: Каталог кэша приложения
*   `bundle`: Пакет приложения; расположение самого приложения на диске (только для чтения)
*   `root`: Все устройство файловой системы

По умолчанию каталоги библиотеки и документы можно синхронизировать с iCloud. Вы также можете заказать два дополнительных файловых систем, `library-nosync` и `documents-nosync` , которые представляют Специальный каталог не синхронизируются в `/Library` или `/Documents` файловой системы.