(function() {
    'use strict';
    
    mobileApp.factory('Surveys', ['DataApi','apiUrl','apiService', Surveys]);
    
    function Surveys(DataApi,apiUrl,apiService){
        var objModel = 'survey';

        return {
            getAll : function (params, callback, useCache) {
                DataApi.getAll(objModel, params, function(res){
                    callback(res);
                },useCache);
            },            
            getRowByUid : function (id, callback){
                DataApi.getRowByUid(objModel, id, function(res){
                    callback(res);
                });
            },
            add: function (params, callback) {
                DataApi.add(objModel, params, function(res){
                    callback(res);
                });    
            },            
            update: function (uid, params, callback) {
                DataApi.update(objModel, uid, params, function(res){
                    callback(res);
                });      
            },
            remove: function (id, params, callback) {
                DataApi.remove(objModel, id, params, function(res){
                    callback(res);
                });
            },
            getRowTask: function (params,  callback) {
                DataApi.getRowByUid(objModel, params.id, function(res){
                    callback(res);
                })    

                /*
                 var par = jQuery.param(params);
                 apiService.exec('GET', apiUrl + '/' + objModel + '/id/' + params.id+'/token/'+params.token+'/?'+par).then(function(response){
                        console.log(objModel + '_getRow: from server..');
                        callback(response.data);
                    });  
                */
            }, 
            getScheduleToday: function (params,  callback) {
                var par = jQuery.param(params);
                 apiService.exec('GET', apiUrl + '/schedule/id/' + params.id+'/token/'+params.token+'/?'+par).then(function(response){
                        console.log(objModel + '_getRow: from server..');
                        callback(response.data);
                    }); 
            }, 
            getComment: function (params,  callback) {
                 var par = jQuery.param(params);
                 apiService.exec('GET', apiUrl + '/comment/id/' + params.id+'/token/'+params.token+'/?'+par).then(function(response){
                        console.log(objModel + '_getRow: from server..');
                        callback(response.data);
                    });  
            },
            postComment: function (params, token,  callback) {
                 //var par = jQuery.param(params);
                 apiService.exec('POST', apiUrl + '/comment?token='+token, params).then(function(response){
                        console.log(objModel + '_getRow: from server..');
                        callback(response.data);
                    });  
            },
            saveSurvey: function (params, token, callback) {
                /*
                apiService.exec('POST', apiUrl + '/' + objModel + '?token='+token+'&saveform=true', params).then(function(response){ 
                    console.log(response);
                    console.log("Server Response: " + response.data.status);
                    callback(response.data);
                });    
                */
                params.token = token;
                DataApi.saveSurvey(objModel, params.uid, params, function(res){
                    callback(res);
                })   
            }, 
            holdSurvey: function (params, token, callback) {
                params.token = token;
                DataApi.holdSurvey(objModel, params.uid, params, function(res){
                    callback(res);
                })   
            }, 
            dataHold: function (params, token, callback) {
                params.token = token;  
                apiService.exec('GET', apiUrl + '/' + objModel + '?token='+token+'&mmId='+params.mmId+'&dataHold=true', params).then(function(response){ 
                    console.log(response);
                    console.log("Server Response: " + response.data.status);
                    callback(response.data);
                });  
            }, 
            updateTask: function (uid, params, token, callback) {
                /*
                apiService.exec('POST', apiUrl + '/' + objModel + '/?token='+token+'&updateTask=true', params).then(function(response){ 
                    console.log(response);
                    console.log("Server Response: " + response.data.status);
                    callback(response.data);
                });    
                */
                params.token = token;
                DataApi.updateTask(objModel, params.uid, params, function(res){
                    callback(res);
                })   
            }, 
            expiredSurvey: function (params, callback) {
                apiService.exec("GET",apiUrl+"/"+objModel+"/expired",params).then(function(res){
                    callback(res);
                });  
            }, 
            clearCache: function() {
                DataApi.clearCache(objModel);
            },
            custom: function(callback){
                // monggo klo mo ada yg custom di sini ajah..
                // klo kurang butuh modul angular kyk $http, tinggal tambahin aja di atas.. gitu kok repot :D
            }
        };
    };
})();
