mobileApp.directive('slidemenu', function() {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            $(element).click(function() {
                $('.menu').toggleClass('click');
                $('#nav, #header, #section').toggleClass('active');

            });
        }
    };
});
mobileApp.directive('navslide', function() {
    return {
        restrict: 'C',
        link: function(scope, element) {
            element.bind("click", function(e) {
                $('.menu').removeClass('click');
                $('#nav, #header, #section').removeClass('active');
            });
        }
    }
});

mobileApp.directive('passwordMatch', function() {
    return {
        require: 'ngModel',
        link: function(scope, elem, attrs, ctrl) {
            var checkMatch, firstPasswordElement, theElement, _i, _len, _ref, _results;
            firstPasswordElement = angular.element(document.getElementById('password-to-verify'));
            checkMatch = function() {
                return scope.$apply(function() {
                    var valid;
                    valid = elem.val() === firstPasswordElement.val();
                    return ctrl.$setValidity('passwordMatch', valid);
                });
            };
            _ref = [firstPasswordElement, elem];
            _results = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                theElement = _ref[_i];
                _results.push(theElement.bind('keyup', function() {
                    return checkMatch();
                }));
            }
            return _results;
        }
    };
});
mobileApp.directive('onValidSubmit', ['$parse', '$timeout',
    function($parse, $timeout) {
        return {
            require: '^form',
            restrict: 'A',
            link: function(scope, element, attrs, form) {
                form.$submitted = false;
                var fn = $parse(attrs.onValidSubmit);
                element.on('submit', function(event) {
                    scope.$apply(function() {
                        element.addClass('ng-submitted');
                        form.$submitted = true;
                        if (form.$valid) {
                            if (typeof fn === 'function') {
                                fn(scope, {
                                    $event: event
                                });
                            }
                        } else {                            
                            alert("Lengkapi data form input & lampiran photo");
                        }
                    });
                });
            }
        }

    }
])
    .directive('validated', ['$parse',
        function($parse) {
            return {
                restrict: 'AEC',
                require: '^form',
                link: function(scope, element, attrs, form) {
                    var inputs = element.find("*");
                    for (var i = 0; i < inputs.length; i++) {
                        (function(input) {
                            var attributes = input.attributes;
                            if (attributes.getNamedItem('ng-model') != void 0 && attributes.getNamedItem('name') != void 0) {
                                var field = form[attributes.name.value];
                                if (field != void 0) {
                                    scope.$watch(function() {
                                        return form.$submitted + "_" + field.$valid;
                                    }, function() {
                                        if (form.$submitted != true) return;
                                        var inp = angular.element(input);
                                        if (inp.hasClass('ng-invalid')) {
                                            element.removeClass('has-success');
                                            element.addClass('has-error');
                                        } else {
                                            element.removeClass('has-error').addClass('has-success');
                                        }
                                    });
                                }
                            }
                        })(inputs[i]);
                    }
                }
            }
        }
    ])
    .directive('checkboxGroup', function() {
        return {
            restrict: 'E',
            controller: function($scope, $attrs) {
                var self = this;
                var ngModels = [];
                var minRequired;
                self.validate = function() {
                    var checkedCount = 0;
                    angular.forEach(ngModels, function(ngModel) {
                        if (ngModel.$modelValue) {
                            checkedCount++;
                        }
                    });
                    console.log('minRequired', minRequired);
                    console.log('checkedCount', checkedCount);
                    var minRequiredValidity = checkedCount >= minRequired;
                    angular.forEach(ngModels, function(ngModel) {
                        ngModel.$setValidity('checkboxGroup-minRequired', minRequiredValidity, self);
                    });
                };

                self.register = function(ngModel) {
                    ngModels.push(ngModel);
                };

                self.deregister = function(ngModel) {
                    var index = this.ngModels.indexOf(ngModel);
                    if (index != -1) {
                        this.ngModels.splice(index, 1);
                    }
                };

                $scope.$watch($attrs.minRequired, function(value) {
                    minRequired = parseInt(value, 10);
                    self.validate();
                });
            }
        };
    })
    .directive('input', function() {
        return {
            restrict: 'E',
            require: ['?^checkboxGroup', '?ngModel'],
            link: function(scope, element, attrs, controllers) {
                var checkboxGroup = controllers[0];
                var ngModel = controllers[1];
                if (attrs.type == 'checkbox' && checkboxGroup && ngModel) {
                    checkboxGroup.register(ngModel);
                    scope.$watch(function() {
                        return ngModel.$modelValue;
                    }, checkboxGroup.validate);
                    // In case we are adding and removing checkboxes dynamically we need to tidy up after outselves.
                    scope.$on('$destroy', function() {
                        checkboxGroup.deregister(ngModel);
                    });
                }
            }
        };
    })
    .directive('gmap',['$window','$parse','$timeout', function($window, $parse, $timeout) {
        var counter = 0,
            prefix = '__ep_gmap_';

        return {
            restrict: 'A',
            replace: false,
            templateUrl: 'scripts/directives/gmaps-route.html',
            link: function(scope, element, attrs, controller) {

                $timeout(function() {
                    var getter = $parse(attrs.gmap),
                        setter = getter.assign;
                    var model = scope.gmap;
                    console.log(model);
                    model.options = ['Driving', 'Bicycling'];
                    model.selectedOption = 'Driving';
                    model.totalKm = 0;

                    setter(scope, model);

                    if ($window.google && $window.google.maps) {
                        gInit();
                    } else {
                        injectGoogle();
                    }

                    $('#map_canvas').css('height',$window.innerHeight+'px');
                    function gInit() {
                        var Location = new google.maps.LatLng(model.Lat, model.Lon),
                            directionsService = new google.maps.DirectionsService(),
                            directionsDisplay = new google.maps.DirectionsRenderer({
                                draggable: false
                            }),

                            mapOptions = {
                                center: Location,
                                zoom: 15,
                                mapTypeId: google.maps.MapTypeId.ROADMAP
                            },
                            map = new google.maps.Map(document.getElementById("map_canvas"),
                                mapOptions);
                        // add your fixed business marker
                        var contentString = model.businessTitle + ' '+ model.fromAddress,
                            marker = new google.maps.Marker({
                                position: Location,
                                map: map,
                                title: model.businessTitle,
                                animation: google.maps.Animation.DROP
                            });
                        // show info Window
                        var infowindow = new google.maps.InfoWindow({
                            content: contentString
                        });
                        google.maps.event.addListener(marker, 'click', function() {
                            infowindow.open(map, marker);
                        });

                        directionsDisplay.setMap(map);
                        //directionsDisplay.setPanel(document.getElementById('directions'));
                        model.setDirections = function() {
                            if(model.customerll[0] != null &&  model.customerll[1] != null) {
                                var cll = new google.maps.LatLng(model.customerll[0], model.customerll[1]);
                            } else {
                                var cll = model.streetAddress;
                            }
                            var selectedMode = model.selectedOption.toUpperCase() || 'DRIVING',
                                from = model.fromAddress,
                                request = {
                                    //origin: model.Lat+' '+model.Lon,
                                    origin: new google.maps.LatLng(model.Lat, model.Lon),
                                    destination: cll,
                                    travelMode: selectedMode,
                                    provideRouteAlternatives: true,
                                    unitSystem: google.maps.UnitSystem.METRIC,
                                    optimizeWaypoints: true,
                                    avoidHighways: true,
                                    avoidTolls: true
                                };
                            if (selectedMode === 'TRANSIT') {
                                request.transitOptions = {
                                    departureTime: new Date()
                                };
                            }

                            directionsService.route(request, function(response, status) {
                                if (status === google.maps.DirectionsStatus.OK) {
                                    directionsDisplay.setDirections(response);
                                } else {
                                    if (angular.isFunction(model.showError)) {
                                        scope.$apply(function() {
                                            model.showError(status);
                                        });
                                    }
                                }
                            });
                        }

                        // Try HTML5 geolocation
                        /*if ("geolocation" in navigator) {
                        navigator.geolocation.getCurrentPosition(function (position) {
                            var pos = new google.maps.LatLng(position.coords.latitude,
                                                             position.coords.longitude);
                            //map.setCenter(Location);
                            scope.$apply(function () {
                                model.fromAddress = pos;
                            });
                            model.setDirections();
                        });
                    }*/

                        google.maps.event.addListener(directionsDisplay, 'directions_changed', function() {

                            computeTotalDistance(directionsDisplay.directions);
                            try {
                                if (directionsDisplay.directions.routes[0].legs[0]) {

                                    scope.$apply(function() {
                                        model.fromAddress = directionsDisplay.directions.routes[0].legs[0].start_address;
                                    });
                                }
                            } catch (e) {}
                        });

                        // fire it up initially
                        model.setDirections();
                        // watch if the mode has changed
                        scope.$watch('gmap.selectedOption', function(newValue, oldValue) {
                            model.setDirections();
                        });

                        function computeTotalDistance(result) {
                            var total = 0,
                                i,
                                myroute = result.routes[0];
                            for (i = 0; i < myroute.legs.length; i++) {
                                total += myroute.legs[i].distance.value;
                            }
                            total = total / 1000;
                            scope.$apply(function() {
                                model.totalKm = total;
                            });
                        }

                    }

                    function injectGoogle() {
                        var cbId = prefix + ++counter;

                        $window[cbId] = gInit;

                        var wf = document.createElement('script');
                        wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
                            '://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false&' + 'callback=' + cbId;
                        wf.type = 'text/javascript';
                        wf.async = 'true';
                        var s = document.getElementsByTagName('script')[0];
                        s.parentNode.insertBefore(wf, s);
                    };
                }, 2000);
            }

        }
    }])
    .directive('resize',['$window', function($window) {
        return function(scope, element) {
            var w = angular.element($window);
            scope.getWindowDimensions = function() {
                return {
                    'h': w.height(),
                    'w': w.width()
                };
            };
            scope.$watch(scope.getWindowDimensions, function(newValue, oldValue) {
                scope.windowHeight = newValue.h;
                scope.windowWidth = newValue.w;

                scope.style = function() {
                    return {
                        'height': (newValue.h - 100) + 'px',
                        'width': (newValue.w - 100) + 'px'
                    };
                };
            }, true);

            w.bind('resize', function() {
                scope.$apply();
            });
        }
    }]);