var fs = require('fs');
var xlsx = require('xlsx');
var cvcsv = require('csv');
var mime = require('mime');
exports = module.exports = XLSX_json;

var excelMimeType = ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.ms-excel']

function XLSX_json(config, callback) {
    var extInput = mime.lookup(config.input);

    if (excelMimeType.indexOf(extInput) > -1) {
        if (!config.input) {
            console.error("You miss a input file");
            process.exit(1);
        }
        var cv = new CV(config, callback);
    } else {
        console.error("Input file not supported");
        process.exit(1);
    }

}

function CV(config, callback) {
    var wb = this.load_xlsx(config.input)
    var csv = this.to_json(wb);
    return  callback(null,csv);
}

CV.prototype.load_xlsx = function(input) {
    return xlsx.readFile(input);
}
CV.prototype.to_json = function(workbook) {
    var result = {};
    workbook.SheetNames.forEach(function(sheetName) {
        var roa = xlsx.utils.sheet_to_row_object_array(workbook.Sheets[sheetName]);
        if(roa.length > 0){
            result[sheetName] = roa;
        }
    });
    return result;
}