var fs = require('fs');
var xlsx = require('xlsx');
var mime = require('mime');
exports = module.exports = XLSX_json;

var excelMimeType = ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.ms-excel']

function XLSX_json(config, callback) {
    var extInput = mime.lookup(config.input);

    if (excelMimeType.indexOf(extInput) > -1) {
        if (!config.input) {
            console.error("You miss a input file");
            process.exit(1);
        }
        var cv = new CV(config, callback);
    } else {
        console.error("Input file not supported");
        process.exit(1);
    }

}

function CV(config, callback) {
    var wb = this.load_xlsx(config.input)
    var json = this.to_json(wb,config);
    var output = config.output;
    if (config.output !== null) {
        var stream = fs.createWriteStream(output, {
            flags: 'w'
        });
        stream.write(JSON.stringify(json));
        return callback(null, json);
    } else {
       return callback(null, json);
    }
}

CV.prototype.load_xlsx = function(input) {
    return xlsx.readFile(input);
}
CV.prototype.to_json = function(workbook,config) {
    var result = {};
    var target_sheet = config.sheet;
    if (target_sheet == null){
        workbook.SheetNames.forEach(function(sheetName) {
            var roa = xlsx.utils.sheet_to_row_object_array(workbook.Sheets[sheetName]);
            if(roa.length > 0){
                result[sheetName] = roa;
            }
        });
    } else {
        target_sheet.forEach(function(sheetName) {
                var roa = xlsx.utils.sheet_to_row_object_array(workbook.Sheets[sheetName]);
                    if(roa.length > 0){
                        result[sheetName] = roa;
                    }
        })

    }
    return result;
}